import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface InvitationConfig extends cdktf.TerraformMetaArguments {
    /**
     * The URL that the user should be redirected to once the invitation is redeemed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#redirect_url Invitation#redirect_url}
     *
     * @stability stable
     */
    readonly redirectUrl: string;
    /**
     * The display name of the user being invited.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#user_display_name Invitation#user_display_name}
     *
     * @stability stable
     */
    readonly userDisplayName?: string;
    /**
     * The email address of the user being invited.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#user_email_address Invitation#user_email_address}
     *
     * @stability stable
     */
    readonly userEmailAddress: string;
    /**
     * The user type of the user being invited.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#user_type Invitation#user_type}
     *
     * @stability stable
     */
    readonly userType?: string;
    /**
     * message block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#message Invitation#message}
     *
     * @stability stable
     */
    readonly message?: InvitationMessage;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#timeouts Invitation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: InvitationTimeouts;
}
/**
 * @stability stable
 */
export interface InvitationMessage {
    /**
     * Email addresses of additional recipients the invitation message should be sent to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#additional_recipients Invitation#additional_recipients}
     *
     * @stability stable
     */
    readonly additionalRecipients?: string[];
    /**
     * Customized message body you want to send if you don't want to send the default message.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#body Invitation#body}
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * The language you want to send the default message in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#language Invitation#language}
     *
     * @stability stable
     */
    readonly language?: string;
}
export declare function invitationMessageToTerraform(struct?: InvitationMessageOutputReference | InvitationMessage): any;
/**
 * @stability stable
 */
export declare class InvitationMessageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): InvitationMessage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: InvitationMessage | undefined);
    private _additionalRecipients?;
    /**
     * @stability stable
     */
    get additionalRecipients(): string[];
    /**
     * @stability stable
     */
    set additionalRecipients(value: string[]);
    /**
     * @stability stable
     */
    resetAdditionalRecipients(): void;
    /**
     * @stability stable
     */
    get additionalRecipientsInput(): string[] | undefined;
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _language?;
    /**
     * @stability stable
     */
    get language(): string;
    /**
     * @stability stable
     */
    set language(value: string);
    /**
     * @stability stable
     */
    resetLanguage(): void;
    /**
     * @stability stable
     */
    get languageInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface InvitationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#create Invitation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#delete Invitation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#read Invitation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#update Invitation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function invitationTimeoutsToTerraform(struct?: InvitationTimeoutsOutputReference | InvitationTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class InvitationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): InvitationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: InvitationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/invitation azuread_invitation}.
 *
 * @stability stable
 */
export declare class Invitation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/invitation azuread_invitation} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: InvitationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get redeemUrl(): string;
    private _redirectUrl?;
    /**
     * @stability stable
     */
    get redirectUrl(): string;
    /**
     * @stability stable
     */
    set redirectUrl(value: string);
    /**
     * @stability stable
     */
    get redirectUrlInput(): string | undefined;
    private _userDisplayName?;
    /**
     * @stability stable
     */
    get userDisplayName(): string;
    /**
     * @stability stable
     */
    set userDisplayName(value: string);
    /**
     * @stability stable
     */
    resetUserDisplayName(): void;
    /**
     * @stability stable
     */
    get userDisplayNameInput(): string | undefined;
    private _userEmailAddress?;
    /**
     * @stability stable
     */
    get userEmailAddress(): string;
    /**
     * @stability stable
     */
    set userEmailAddress(value: string);
    /**
     * @stability stable
     */
    get userEmailAddressInput(): string | undefined;
    /**
     * @stability stable
     */
    get userId(): string;
    private _userType?;
    /**
     * @stability stable
     */
    get userType(): string;
    /**
     * @stability stable
     */
    set userType(value: string);
    /**
     * @stability stable
     */
    resetUserType(): void;
    /**
     * @stability stable
     */
    get userTypeInput(): string | undefined;
    private _message;
    /**
     * @stability stable
     */
    get message(): InvitationMessageOutputReference;
    /**
     * @stability stable
     */
    putMessage(value: InvitationMessage): void;
    /**
     * @stability stable
     */
    resetMessage(): void;
    /**
     * @stability stable
     */
    get messageInput(): InvitationMessage | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): InvitationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: InvitationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): InvitationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
