import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NamedLocationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#display_name NamedLocation#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * country block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#country NamedLocation#country}
     *
     * @stability stable
     */
    readonly country?: NamedLocationCountry;
    /**
     * ip block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#ip NamedLocation#ip}
     *
     * @stability stable
     */
    readonly ip?: NamedLocationIp;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#timeouts NamedLocation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NamedLocationTimeouts;
}
/**
 * @stability stable
 */
export interface NamedLocationCountry {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#countries_and_regions NamedLocation#countries_and_regions}.
     *
     * @stability stable
     */
    readonly countriesAndRegions: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#include_unknown_countries_and_regions NamedLocation#include_unknown_countries_and_regions}.
     *
     * @stability stable
     */
    readonly includeUnknownCountriesAndRegions?: boolean | cdktf.IResolvable;
}
export declare function namedLocationCountryToTerraform(struct?: NamedLocationCountryOutputReference | NamedLocationCountry): any;
/**
 * @stability stable
 */
export declare class NamedLocationCountryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NamedLocationCountry | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NamedLocationCountry | undefined);
    private _countriesAndRegions?;
    /**
     * @stability stable
     */
    get countriesAndRegions(): string[];
    /**
     * @stability stable
     */
    set countriesAndRegions(value: string[]);
    /**
     * @stability stable
     */
    get countriesAndRegionsInput(): string[] | undefined;
    private _includeUnknownCountriesAndRegions?;
    /**
     * @stability stable
     */
    get includeUnknownCountriesAndRegions(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeUnknownCountriesAndRegions(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeUnknownCountriesAndRegions(): void;
    /**
     * @stability stable
     */
    get includeUnknownCountriesAndRegionsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface NamedLocationIp {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#ip_ranges NamedLocation#ip_ranges}.
     *
     * @stability stable
     */
    readonly ipRanges: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#trusted NamedLocation#trusted}.
     *
     * @stability stable
     */
    readonly trusted?: boolean | cdktf.IResolvable;
}
export declare function namedLocationIpToTerraform(struct?: NamedLocationIpOutputReference | NamedLocationIp): any;
/**
 * @stability stable
 */
export declare class NamedLocationIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NamedLocationIp | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NamedLocationIp | undefined);
    private _ipRanges?;
    /**
     * @stability stable
     */
    get ipRanges(): string[];
    /**
     * @stability stable
     */
    set ipRanges(value: string[]);
    /**
     * @stability stable
     */
    get ipRangesInput(): string[] | undefined;
    private _trusted?;
    /**
     * @stability stable
     */
    get trusted(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set trusted(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTrusted(): void;
    /**
     * @stability stable
     */
    get trustedInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface NamedLocationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#create NamedLocation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#delete NamedLocation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#read NamedLocation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/named_location#update NamedLocation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function namedLocationTimeoutsToTerraform(struct?: NamedLocationTimeoutsOutputReference | NamedLocationTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class NamedLocationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NamedLocationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NamedLocationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/named_location azuread_named_location}.
 *
 * @stability stable
 */
export declare class NamedLocation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/named_location azuread_named_location} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NamedLocationConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _country;
    /**
     * @stability stable
     */
    get country(): NamedLocationCountryOutputReference;
    /**
     * @stability stable
     */
    putCountry(value: NamedLocationCountry): void;
    /**
     * @stability stable
     */
    resetCountry(): void;
    /**
     * @stability stable
     */
    get countryInput(): NamedLocationCountry | undefined;
    private _ip;
    /**
     * @stability stable
     */
    get ip(): NamedLocationIpOutputReference;
    /**
     * @stability stable
     */
    putIp(value: NamedLocationIp): void;
    /**
     * @stability stable
     */
    resetIp(): void;
    /**
     * @stability stable
     */
    get ipInput(): NamedLocationIp | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NamedLocationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NamedLocationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NamedLocationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
