import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServicePrincipalDelegatedPermissionGrantConfig extends cdktf.TerraformMetaArguments {
    /**
     * A set of claim values for delegated permission scopes which should be included in access tokens for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#claim_values ServicePrincipalDelegatedPermissionGrant#claim_values}
     *
     * @stability stable
     */
    readonly claimValues: string[];
    /**
     * The object ID of the service principal representing the resource to be accessed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#resource_service_principal_object_id ServicePrincipalDelegatedPermissionGrant#resource_service_principal_object_id}
     *
     * @stability stable
     */
    readonly resourceServicePrincipalObjectId: string;
    /**
     * The object ID of the service principal for which this delegated permission grant should be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#service_principal_object_id ServicePrincipalDelegatedPermissionGrant#service_principal_object_id}
     *
     * @stability stable
     */
    readonly servicePrincipalObjectId: string;
    /**
     * The object ID of the user on behalf of whom the service principal is authorized to access the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#user_object_id ServicePrincipalDelegatedPermissionGrant#user_object_id}
     *
     * @stability stable
     */
    readonly userObjectId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#timeouts ServicePrincipalDelegatedPermissionGrant#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServicePrincipalDelegatedPermissionGrantTimeouts;
}
/**
 * @stability stable
 */
export interface ServicePrincipalDelegatedPermissionGrantTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#create ServicePrincipalDelegatedPermissionGrant#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#delete ServicePrincipalDelegatedPermissionGrant#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#read ServicePrincipalDelegatedPermissionGrant#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant#update ServicePrincipalDelegatedPermissionGrant#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function servicePrincipalDelegatedPermissionGrantTimeoutsToTerraform(struct?: ServicePrincipalDelegatedPermissionGrantTimeoutsOutputReference | ServicePrincipalDelegatedPermissionGrantTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ServicePrincipalDelegatedPermissionGrantTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicePrincipalDelegatedPermissionGrantTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicePrincipalDelegatedPermissionGrantTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant azuread_service_principal_delegated_permission_grant}.
 *
 * @stability stable
 */
export declare class ServicePrincipalDelegatedPermissionGrant extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_delegated_permission_grant azuread_service_principal_delegated_permission_grant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServicePrincipalDelegatedPermissionGrantConfig);
    private _claimValues?;
    /**
     * @stability stable
     */
    get claimValues(): string[];
    /**
     * @stability stable
     */
    set claimValues(value: string[]);
    /**
     * @stability stable
     */
    get claimValuesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _resourceServicePrincipalObjectId?;
    /**
     * @stability stable
     */
    get resourceServicePrincipalObjectId(): string;
    /**
     * @stability stable
     */
    set resourceServicePrincipalObjectId(value: string);
    /**
     * @stability stable
     */
    get resourceServicePrincipalObjectIdInput(): string | undefined;
    private _servicePrincipalObjectId?;
    /**
     * @stability stable
     */
    get servicePrincipalObjectId(): string;
    /**
     * @stability stable
     */
    set servicePrincipalObjectId(value: string);
    /**
     * @stability stable
     */
    get servicePrincipalObjectIdInput(): string | undefined;
    private _userObjectId?;
    /**
     * @stability stable
     */
    get userObjectId(): string;
    /**
     * @stability stable
     */
    set userObjectId(value: string);
    /**
     * @stability stable
     */
    resetUserObjectId(): void;
    /**
     * @stability stable
     */
    get userObjectIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServicePrincipalDelegatedPermissionGrantTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServicePrincipalDelegatedPermissionGrantTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServicePrincipalDelegatedPermissionGrantTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
