import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServicePrincipalConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether or not the service principal account is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#account_enabled ServicePrincipal#account_enabled}
     *
     * @stability stable
     */
    readonly accountEnabled?: boolean | cdktf.IResolvable;
    /**
     * A list of alternative names, used to retrieve service principals by subscription, identify resource group and full resource ids for managed identities.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#alternative_names ServicePrincipal#alternative_names}
     *
     * @stability stable
     */
    readonly alternativeNames?: string[];
    /**
     * Whether this service principal requires an app role assignment to a user or group before Azure AD will issue a user or access token to the application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#app_role_assignment_required ServicePrincipal#app_role_assignment_required}
     *
     * @stability stable
     */
    readonly appRoleAssignmentRequired?: boolean | cdktf.IResolvable;
    /**
     * The application ID (client ID) of the application for which to create a service principal.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#application_id ServicePrincipal#application_id}
     *
     * @stability stable
     */
    readonly applicationId: string;
    /**
     * Description of the service principal provided for internal end-users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#description ServicePrincipal#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The URL where the service provider redirects the user to Azure AD to authenticate.
     *
     * Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#login_url ServicePrincipal#login_url}
     *
     * @stability stable
     */
    readonly loginUrl?: string;
    /**
     * Free text field to capture information about the service principal, typically used for operational purposes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#notes ServicePrincipal#notes}
     *
     * @stability stable
     */
    readonly notes?: string;
    /**
     * List of email addresses where Azure AD sends a notification when the active certificate is near the expiration date.
     *
     * This is only for the certificates used to sign the SAML token issued for Azure AD Gallery applications
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#notification_email_addresses ServicePrincipal#notification_email_addresses}
     *
     * @stability stable
     */
    readonly notificationEmailAddresses?: string[];
    /**
     * A list of object IDs of principals that will be granted ownership of the service principal.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#owners ServicePrincipal#owners}
     *
     * @stability stable
     */
    readonly owners?: string[];
    /**
     * The single sign-on mode configured for this application.
     *
     * Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My Apps
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#preferred_single_sign_on_mode ServicePrincipal#preferred_single_sign_on_mode}
     *
     * @stability stable
     */
    readonly preferredSingleSignOnMode?: string;
    /**
     * A set of tags to apply to the service principal.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#tags ServicePrincipal#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * When true, the resource will return an existing service principal instead of failing with an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#use_existing ServicePrincipal#use_existing}
     *
     * @stability stable
     */
    readonly useExisting?: boolean | cdktf.IResolvable;
    /**
     * feature_tags block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#feature_tags ServicePrincipal#feature_tags}
     *
     * @stability stable
     */
    readonly featureTags?: ServicePrincipalFeatureTags[] | cdktf.IResolvable;
    /**
     * features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#features ServicePrincipal#features}
     *
     * @stability stable
     */
    readonly features?: ServicePrincipalFeatures[] | cdktf.IResolvable;
    /**
     * saml_single_sign_on block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#saml_single_sign_on ServicePrincipal#saml_single_sign_on}
     *
     * @stability stable
     */
    readonly samlSingleSignOn?: ServicePrincipalSamlSingleSignOn;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#timeouts ServicePrincipal#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServicePrincipalTimeouts;
}
/**
 * @stability stable
 */
export declare class ServicePrincipalAppRoles extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allowedMemberTypes(): string[];
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class ServicePrincipalOauth2PermissionScopes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get adminConsentDescription(): string;
    /**
     * @stability stable
     */
    get adminConsentDisplayName(): string;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get userConsentDescription(): string;
    /**
     * @stability stable
     */
    get userConsentDisplayName(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export interface ServicePrincipalFeatureTags {
    /**
     * Whether this service principal represents a custom SAML application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#custom_single_sign_on ServicePrincipal#custom_single_sign_on}
     *
     * @stability stable
     */
    readonly customSingleSignOn?: boolean | cdktf.IResolvable;
    /**
     * Whether this service principal represents an Enterprise Application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#enterprise ServicePrincipal#enterprise}
     *
     * @stability stable
     */
    readonly enterprise?: boolean | cdktf.IResolvable;
    /**
     * Whether this service principal represents a gallery application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#gallery ServicePrincipal#gallery}
     *
     * @stability stable
     */
    readonly gallery?: boolean | cdktf.IResolvable;
    /**
     * Whether this app is invisible to users in My Apps and Office 365 Launcher.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#hide ServicePrincipal#hide}
     *
     * @stability stable
     */
    readonly hide?: boolean | cdktf.IResolvable;
}
export declare function servicePrincipalFeatureTagsToTerraform(struct?: ServicePrincipalFeatureTags | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServicePrincipalFeatures {
    /**
     * Whether this service principal represents a custom SAML application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#custom_single_sign_on_app ServicePrincipal#custom_single_sign_on_app}
     *
     * @stability stable
     */
    readonly customSingleSignOnApp?: boolean | cdktf.IResolvable;
    /**
     * Whether this service principal represents an Enterprise Application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#enterprise_application ServicePrincipal#enterprise_application}
     *
     * @stability stable
     */
    readonly enterpriseApplication?: boolean | cdktf.IResolvable;
    /**
     * Whether this service principal represents a gallery application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#gallery_application ServicePrincipal#gallery_application}
     *
     * @stability stable
     */
    readonly galleryApplication?: boolean | cdktf.IResolvable;
    /**
     * Whether this app is visible to users in My Apps and Office 365 Launcher.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#visible_to_users ServicePrincipal#visible_to_users}
     *
     * @stability stable
     */
    readonly visibleToUsers?: boolean | cdktf.IResolvable;
}
export declare function servicePrincipalFeaturesToTerraform(struct?: ServicePrincipalFeatures | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface ServicePrincipalSamlSingleSignOn {
    /**
     * The relative URI the service provider would redirect to after completion of the single sign-on flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#relay_state ServicePrincipal#relay_state}
     *
     * @stability stable
     */
    readonly relayState?: string;
}
export declare function servicePrincipalSamlSingleSignOnToTerraform(struct?: ServicePrincipalSamlSingleSignOnOutputReference | ServicePrincipalSamlSingleSignOn): any;
/**
 * @stability stable
 */
export declare class ServicePrincipalSamlSingleSignOnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicePrincipalSamlSingleSignOn | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicePrincipalSamlSingleSignOn | undefined);
    private _relayState?;
    /**
     * @stability stable
     */
    get relayState(): string;
    /**
     * @stability stable
     */
    set relayState(value: string);
    /**
     * @stability stable
     */
    resetRelayState(): void;
    /**
     * @stability stable
     */
    get relayStateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ServicePrincipalTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#create ServicePrincipal#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#delete ServicePrincipal#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#read ServicePrincipal#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#update ServicePrincipal#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function servicePrincipalTimeoutsToTerraform(struct?: ServicePrincipalTimeoutsOutputReference | ServicePrincipalTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ServicePrincipalTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicePrincipalTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicePrincipalTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/service_principal azuread_service_principal}.
 *
 * @stability stable
 */
export declare class ServicePrincipal extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/service_principal azuread_service_principal} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServicePrincipalConfig);
    private _accountEnabled?;
    /**
     * @stability stable
     */
    get accountEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accountEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccountEnabled(): void;
    /**
     * @stability stable
     */
    get accountEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _alternativeNames?;
    /**
     * @stability stable
     */
    get alternativeNames(): string[];
    /**
     * @stability stable
     */
    set alternativeNames(value: string[]);
    /**
     * @stability stable
     */
    resetAlternativeNames(): void;
    /**
     * @stability stable
     */
    get alternativeNamesInput(): string[] | undefined;
    private _appRoleAssignmentRequired?;
    /**
     * @stability stable
     */
    get appRoleAssignmentRequired(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set appRoleAssignmentRequired(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAppRoleAssignmentRequired(): void;
    /**
     * @stability stable
     */
    get appRoleAssignmentRequiredInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    appRoleIds(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    appRoles(index: string): ServicePrincipalAppRoles;
    private _applicationId?;
    /**
     * @stability stable
     */
    get applicationId(): string;
    /**
     * @stability stable
     */
    set applicationId(value: string);
    /**
     * @stability stable
     */
    get applicationIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get applicationTenantId(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get homepageUrl(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _loginUrl?;
    /**
     * @stability stable
     */
    get loginUrl(): string;
    /**
     * @stability stable
     */
    set loginUrl(value: string);
    /**
     * @stability stable
     */
    resetLoginUrl(): void;
    /**
     * @stability stable
     */
    get loginUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get logoutUrl(): string;
    private _notes?;
    /**
     * @stability stable
     */
    get notes(): string;
    /**
     * @stability stable
     */
    set notes(value: string);
    /**
     * @stability stable
     */
    resetNotes(): void;
    /**
     * @stability stable
     */
    get notesInput(): string | undefined;
    private _notificationEmailAddresses?;
    /**
     * @stability stable
     */
    get notificationEmailAddresses(): string[];
    /**
     * @stability stable
     */
    set notificationEmailAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetNotificationEmailAddresses(): void;
    /**
     * @stability stable
     */
    get notificationEmailAddressesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    oauth2PermissionScopeIds(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    oauth2PermissionScopes(index: string): ServicePrincipalOauth2PermissionScopes;
    /**
     * @stability stable
     */
    get objectId(): string;
    private _owners?;
    /**
     * @stability stable
     */
    get owners(): string[];
    /**
     * @stability stable
     */
    set owners(value: string[]);
    /**
     * @stability stable
     */
    resetOwners(): void;
    /**
     * @stability stable
     */
    get ownersInput(): string[] | undefined;
    private _preferredSingleSignOnMode?;
    /**
     * @stability stable
     */
    get preferredSingleSignOnMode(): string;
    /**
     * @stability stable
     */
    set preferredSingleSignOnMode(value: string);
    /**
     * @stability stable
     */
    resetPreferredSingleSignOnMode(): void;
    /**
     * @stability stable
     */
    get preferredSingleSignOnModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get redirectUris(): string[];
    /**
     * @stability stable
     */
    get samlMetadataUrl(): string;
    /**
     * @stability stable
     */
    get servicePrincipalNames(): string[];
    /**
     * @stability stable
     */
    get signInAudience(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _useExisting?;
    /**
     * @stability stable
     */
    get useExisting(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useExisting(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseExisting(): void;
    /**
     * @stability stable
     */
    get useExistingInput(): boolean | cdktf.IResolvable | undefined;
    private _featureTags?;
    /**
     * @stability stable
     */
    get featureTags(): ServicePrincipalFeatureTags[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set featureTags(value: ServicePrincipalFeatureTags[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFeatureTags(): void;
    /**
     * @stability stable
     */
    get featureTagsInput(): cdktf.IResolvable | ServicePrincipalFeatureTags[] | undefined;
    private _features?;
    /**
     * @stability stable
     */
    get features(): ServicePrincipalFeatures[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set features(value: ServicePrincipalFeatures[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFeatures(): void;
    /**
     * @stability stable
     */
    get featuresInput(): cdktf.IResolvable | ServicePrincipalFeatures[] | undefined;
    private _samlSingleSignOn;
    /**
     * @stability stable
     */
    get samlSingleSignOn(): ServicePrincipalSamlSingleSignOnOutputReference;
    /**
     * @stability stable
     */
    putSamlSingleSignOn(value: ServicePrincipalSamlSingleSignOn): void;
    /**
     * @stability stable
     */
    resetSamlSingleSignOn(): void;
    /**
     * @stability stable
     */
    get samlSingleSignOnInput(): ServicePrincipalSamlSingleSignOn | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServicePrincipalTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServicePrincipalTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServicePrincipalTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
