import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether or not the account should be enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#account_enabled User#account_enabled}
     *
     * @stability stable
     */
    readonly accountEnabled?: boolean | cdktf.IResolvable;
    /**
     * The age group of the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#age_group User#age_group}
     *
     * @stability stable
     */
    readonly ageGroup?: string;
    /**
     * The telephone numbers for the user.
     *
     * Only one number can be set for this property. Read-only for users synced with Azure AD Connect
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#business_phones User#business_phones}
     *
     * @stability stable
     */
    readonly businessPhones?: string[];
    /**
     * The city in which the user is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#city User#city}
     *
     * @stability stable
     */
    readonly city?: string;
    /**
     * The company name which the user is associated.
     *
     * This property can be useful for describing the company that an external user comes from
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#company_name User#company_name}
     *
     * @stability stable
     */
    readonly companyName?: string;
    /**
     * Whether consent has been obtained for minors.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#consent_provided_for_minor User#consent_provided_for_minor}
     *
     * @stability stable
     */
    readonly consentProvidedForMinor?: string;
    /**
     * The cost center associated with the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#cost_center User#cost_center}
     *
     * @stability stable
     */
    readonly costCenter?: string;
    /**
     * The country/region in which the user is located, e.g. `US` or `UK`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#country User#country}
     *
     * @stability stable
     */
    readonly country?: string;
    /**
     * The name for the department in which the user works.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#department User#department}
     *
     * @stability stable
     */
    readonly department?: string;
    /**
     * Whether the users password is exempt from expiring.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#disable_password_expiration User#disable_password_expiration}
     *
     * @stability stable
     */
    readonly disablePasswordExpiration?: boolean | cdktf.IResolvable;
    /**
     * Whether the user is allowed weaker passwords than the default policy to be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#disable_strong_password User#disable_strong_password}
     *
     * @stability stable
     */
    readonly disableStrongPassword?: boolean | cdktf.IResolvable;
    /**
     * The name to display in the address book for the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#display_name User#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The name of the division in which the user works.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#division User#division}
     *
     * @stability stable
     */
    readonly division?: string;
    /**
     * The employee identifier assigned to the user by the organisation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#employee_id User#employee_id}
     *
     * @stability stable
     */
    readonly employeeId?: string;
    /**
     * Captures enterprise worker type. For example, Employee, Contractor, Consultant, or Vendor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#employee_type User#employee_type}
     *
     * @stability stable
     */
    readonly employeeType?: string;
    /**
     * The fax number of the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#fax_number User#fax_number}
     *
     * @stability stable
     */
    readonly faxNumber?: string;
    /**
     * Whether the user is forced to change the password during the next sign-in.
     *
     * Only takes effect when also changing the password
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#force_password_change User#force_password_change}
     *
     * @stability stable
     */
    readonly forcePasswordChange?: boolean | cdktf.IResolvable;
    /**
     * The given name (first name) of the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#given_name User#given_name}
     *
     * @stability stable
     */
    readonly givenName?: string;
    /**
     * The user’s job title.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#job_title User#job_title}
     *
     * @stability stable
     */
    readonly jobTitle?: string;
    /**
     * The SMTP address for the user. Cannot be unset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#mail User#mail}
     *
     * @stability stable
     */
    readonly mail?: string;
    /**
     * The mail alias for the user. Defaults to the user name part of the user principal name (UPN).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#mail_nickname User#mail_nickname}
     *
     * @stability stable
     */
    readonly mailNickname?: string;
    /**
     * The object ID of the user's manager.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#manager_id User#manager_id}
     *
     * @stability stable
     */
    readonly managerId?: string;
    /**
     * The primary cellular telephone number for the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#mobile_phone User#mobile_phone}
     *
     * @stability stable
     */
    readonly mobilePhone?: string;
    /**
     * The office location in the user's place of business.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#office_location User#office_location}
     *
     * @stability stable
     */
    readonly officeLocation?: string;
    /**
     * The value used to associate an on-premise Active Directory user account with their Azure AD user object.
     *
     * This must be specified if you are using a federated domain for the user's `user_principal_name` property when creating a new user account
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#onpremises_immutable_id User#onpremises_immutable_id}
     *
     * @stability stable
     */
    readonly onpremisesImmutableId?: string;
    /**
     * Additional email addresses for the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#other_mails User#other_mails}
     *
     * @stability stable
     */
    readonly otherMails?: string[];
    /**
     * The password for the user.
     *
     * The password must satisfy minimum requirements as specified by the password policy. The maximum length is 256 characters. This property is required when creating a new user
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#password User#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * The postal code for the user's postal address.
     *
     * The postal code is specific to the user's country/region. In the United States of America, this attribute contains the ZIP code
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#postal_code User#postal_code}
     *
     * @stability stable
     */
    readonly postalCode?: string;
    /**
     * The user's preferred language, in ISO 639-1 notation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#preferred_language User#preferred_language}
     *
     * @stability stable
     */
    readonly preferredLanguage?: string;
    /**
     * Whether or not the Outlook global address list should include this user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#show_in_address_list User#show_in_address_list}
     *
     * @stability stable
     */
    readonly showInAddressList?: boolean | cdktf.IResolvable;
    /**
     * The state or province in the user's address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#state User#state}
     *
     * @stability stable
     */
    readonly state?: string;
    /**
     * The street address of the user's place of business.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#street_address User#street_address}
     *
     * @stability stable
     */
    readonly streetAddress?: string;
    /**
     * The user's surname (family name or last name).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#surname User#surname}
     *
     * @stability stable
     */
    readonly surname?: string;
    /**
     * The usage location of the user.
     *
     * Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. The usage location is a two letter country code (ISO standard 3166). Examples include: `NO`, `JP`, and `GB`. Cannot be reset to null once set
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#usage_location User#usage_location}
     *
     * @stability stable
     */
    readonly usageLocation?: string;
    /**
     * The user principal name (UPN) of the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#user_principal_name User#user_principal_name}
     *
     * @stability stable
     */
    readonly userPrincipalName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#timeouts User#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: UserTimeouts;
}
/**
 * @stability stable
 */
export interface UserTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#create User#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#delete User#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#read User#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/user#update User#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function userTimeoutsToTerraform(struct?: UserTimeoutsOutputReference | UserTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class UserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): UserTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: UserTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azuread/r/user azuread_user}.
 *
 * @stability stable
 */
export declare class User extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/user azuread_user} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserConfig);
    /**
     * @stability stable
     */
    get aboutMe(): string;
    private _accountEnabled?;
    /**
     * @stability stable
     */
    get accountEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set accountEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAccountEnabled(): void;
    /**
     * @stability stable
     */
    get accountEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ageGroup?;
    /**
     * @stability stable
     */
    get ageGroup(): string;
    /**
     * @stability stable
     */
    set ageGroup(value: string);
    /**
     * @stability stable
     */
    resetAgeGroup(): void;
    /**
     * @stability stable
     */
    get ageGroupInput(): string | undefined;
    private _businessPhones?;
    /**
     * @stability stable
     */
    get businessPhones(): string[];
    /**
     * @stability stable
     */
    set businessPhones(value: string[]);
    /**
     * @stability stable
     */
    resetBusinessPhones(): void;
    /**
     * @stability stable
     */
    get businessPhonesInput(): string[] | undefined;
    private _city?;
    /**
     * @stability stable
     */
    get city(): string;
    /**
     * @stability stable
     */
    set city(value: string);
    /**
     * @stability stable
     */
    resetCity(): void;
    /**
     * @stability stable
     */
    get cityInput(): string | undefined;
    private _companyName?;
    /**
     * @stability stable
     */
    get companyName(): string;
    /**
     * @stability stable
     */
    set companyName(value: string);
    /**
     * @stability stable
     */
    resetCompanyName(): void;
    /**
     * @stability stable
     */
    get companyNameInput(): string | undefined;
    private _consentProvidedForMinor?;
    /**
     * @stability stable
     */
    get consentProvidedForMinor(): string;
    /**
     * @stability stable
     */
    set consentProvidedForMinor(value: string);
    /**
     * @stability stable
     */
    resetConsentProvidedForMinor(): void;
    /**
     * @stability stable
     */
    get consentProvidedForMinorInput(): string | undefined;
    private _costCenter?;
    /**
     * @stability stable
     */
    get costCenter(): string;
    /**
     * @stability stable
     */
    set costCenter(value: string);
    /**
     * @stability stable
     */
    resetCostCenter(): void;
    /**
     * @stability stable
     */
    get costCenterInput(): string | undefined;
    private _country?;
    /**
     * @stability stable
     */
    get country(): string;
    /**
     * @stability stable
     */
    set country(value: string);
    /**
     * @stability stable
     */
    resetCountry(): void;
    /**
     * @stability stable
     */
    get countryInput(): string | undefined;
    /**
     * @stability stable
     */
    get creationType(): string;
    private _department?;
    /**
     * @stability stable
     */
    get department(): string;
    /**
     * @stability stable
     */
    set department(value: string);
    /**
     * @stability stable
     */
    resetDepartment(): void;
    /**
     * @stability stable
     */
    get departmentInput(): string | undefined;
    private _disablePasswordExpiration?;
    /**
     * @stability stable
     */
    get disablePasswordExpiration(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disablePasswordExpiration(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisablePasswordExpiration(): void;
    /**
     * @stability stable
     */
    get disablePasswordExpirationInput(): boolean | cdktf.IResolvable | undefined;
    private _disableStrongPassword?;
    /**
     * @stability stable
     */
    get disableStrongPassword(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableStrongPassword(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableStrongPassword(): void;
    /**
     * @stability stable
     */
    get disableStrongPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _division?;
    /**
     * @stability stable
     */
    get division(): string;
    /**
     * @stability stable
     */
    set division(value: string);
    /**
     * @stability stable
     */
    resetDivision(): void;
    /**
     * @stability stable
     */
    get divisionInput(): string | undefined;
    private _employeeId?;
    /**
     * @stability stable
     */
    get employeeId(): string;
    /**
     * @stability stable
     */
    set employeeId(value: string);
    /**
     * @stability stable
     */
    resetEmployeeId(): void;
    /**
     * @stability stable
     */
    get employeeIdInput(): string | undefined;
    private _employeeType?;
    /**
     * @stability stable
     */
    get employeeType(): string;
    /**
     * @stability stable
     */
    set employeeType(value: string);
    /**
     * @stability stable
     */
    resetEmployeeType(): void;
    /**
     * @stability stable
     */
    get employeeTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get externalUserState(): string;
    private _faxNumber?;
    /**
     * @stability stable
     */
    get faxNumber(): string;
    /**
     * @stability stable
     */
    set faxNumber(value: string);
    /**
     * @stability stable
     */
    resetFaxNumber(): void;
    /**
     * @stability stable
     */
    get faxNumberInput(): string | undefined;
    private _forcePasswordChange?;
    /**
     * @stability stable
     */
    get forcePasswordChange(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set forcePasswordChange(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetForcePasswordChange(): void;
    /**
     * @stability stable
     */
    get forcePasswordChangeInput(): boolean | cdktf.IResolvable | undefined;
    private _givenName?;
    /**
     * @stability stable
     */
    get givenName(): string;
    /**
     * @stability stable
     */
    set givenName(value: string);
    /**
     * @stability stable
     */
    resetGivenName(): void;
    /**
     * @stability stable
     */
    get givenNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get imAddresses(): string[];
    private _jobTitle?;
    /**
     * @stability stable
     */
    get jobTitle(): string;
    /**
     * @stability stable
     */
    set jobTitle(value: string);
    /**
     * @stability stable
     */
    resetJobTitle(): void;
    /**
     * @stability stable
     */
    get jobTitleInput(): string | undefined;
    private _mail?;
    /**
     * @stability stable
     */
    get mail(): string;
    /**
     * @stability stable
     */
    set mail(value: string);
    /**
     * @stability stable
     */
    resetMail(): void;
    /**
     * @stability stable
     */
    get mailInput(): string | undefined;
    private _mailNickname?;
    /**
     * @stability stable
     */
    get mailNickname(): string;
    /**
     * @stability stable
     */
    set mailNickname(value: string);
    /**
     * @stability stable
     */
    resetMailNickname(): void;
    /**
     * @stability stable
     */
    get mailNicknameInput(): string | undefined;
    private _managerId?;
    /**
     * @stability stable
     */
    get managerId(): string;
    /**
     * @stability stable
     */
    set managerId(value: string);
    /**
     * @stability stable
     */
    resetManagerId(): void;
    /**
     * @stability stable
     */
    get managerIdInput(): string | undefined;
    private _mobilePhone?;
    /**
     * @stability stable
     */
    get mobilePhone(): string;
    /**
     * @stability stable
     */
    set mobilePhone(value: string);
    /**
     * @stability stable
     */
    resetMobilePhone(): void;
    /**
     * @stability stable
     */
    get mobilePhoneInput(): string | undefined;
    /**
     * @stability stable
     */
    get objectId(): string;
    private _officeLocation?;
    /**
     * @stability stable
     */
    get officeLocation(): string;
    /**
     * @stability stable
     */
    set officeLocation(value: string);
    /**
     * @stability stable
     */
    resetOfficeLocation(): void;
    /**
     * @stability stable
     */
    get officeLocationInput(): string | undefined;
    /**
     * @stability stable
     */
    get onpremisesDistinguishedName(): string;
    /**
     * @stability stable
     */
    get onpremisesDomainName(): string;
    private _onpremisesImmutableId?;
    /**
     * @stability stable
     */
    get onpremisesImmutableId(): string;
    /**
     * @stability stable
     */
    set onpremisesImmutableId(value: string);
    /**
     * @stability stable
     */
    resetOnpremisesImmutableId(): void;
    /**
     * @stability stable
     */
    get onpremisesImmutableIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get onpremisesSamAccountName(): string;
    /**
     * @stability stable
     */
    get onpremisesSecurityIdentifier(): string;
    /**
     * @stability stable
     */
    get onpremisesSyncEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get onpremisesUserPrincipalName(): string;
    private _otherMails?;
    /**
     * @stability stable
     */
    get otherMails(): string[];
    /**
     * @stability stable
     */
    set otherMails(value: string[]);
    /**
     * @stability stable
     */
    resetOtherMails(): void;
    /**
     * @stability stable
     */
    get otherMailsInput(): string[] | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _postalCode?;
    /**
     * @stability stable
     */
    get postalCode(): string;
    /**
     * @stability stable
     */
    set postalCode(value: string);
    /**
     * @stability stable
     */
    resetPostalCode(): void;
    /**
     * @stability stable
     */
    get postalCodeInput(): string | undefined;
    private _preferredLanguage?;
    /**
     * @stability stable
     */
    get preferredLanguage(): string;
    /**
     * @stability stable
     */
    set preferredLanguage(value: string);
    /**
     * @stability stable
     */
    resetPreferredLanguage(): void;
    /**
     * @stability stable
     */
    get preferredLanguageInput(): string | undefined;
    /**
     * @stability stable
     */
    get proxyAddresses(): string[];
    private _showInAddressList?;
    /**
     * @stability stable
     */
    get showInAddressList(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set showInAddressList(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShowInAddressList(): void;
    /**
     * @stability stable
     */
    get showInAddressListInput(): boolean | cdktf.IResolvable | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    resetState(): void;
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    private _streetAddress?;
    /**
     * @stability stable
     */
    get streetAddress(): string;
    /**
     * @stability stable
     */
    set streetAddress(value: string);
    /**
     * @stability stable
     */
    resetStreetAddress(): void;
    /**
     * @stability stable
     */
    get streetAddressInput(): string | undefined;
    private _surname?;
    /**
     * @stability stable
     */
    get surname(): string;
    /**
     * @stability stable
     */
    set surname(value: string);
    /**
     * @stability stable
     */
    resetSurname(): void;
    /**
     * @stability stable
     */
    get surnameInput(): string | undefined;
    private _usageLocation?;
    /**
     * @stability stable
     */
    get usageLocation(): string;
    /**
     * @stability stable
     */
    set usageLocation(value: string);
    /**
     * @stability stable
     */
    resetUsageLocation(): void;
    /**
     * @stability stable
     */
    get usageLocationInput(): string | undefined;
    private _userPrincipalName?;
    /**
     * @stability stable
     */
    get userPrincipalName(): string;
    /**
     * @stability stable
     */
    set userPrincipalName(value: string);
    /**
     * @stability stable
     */
    get userPrincipalNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get userType(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): UserTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: UserTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): UserTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
