# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import deb as _deb
from .. import runner as _runner
from .. import solana as _solana
from .. import ssh as _ssh

__all__ = ['TransferArgs', 'Transfer']

@pulumi.input_type
class TransferArgs:
    def __init__(__self__, *,
                 amount: pulumi.Input[_builtins.float],
                 connection: pulumi.Input['_ssh.ConnectionArgs'],
                 recipient_pubkey: pulumi.Input[_builtins.str],
                 transaction_options: pulumi.Input['_solana.TxnOptionsArgs'],
                 allow_unfunded_recipient: Optional[pulumi.Input[_builtins.bool]] = None,
                 runner_config: Optional[pulumi.Input['_runner.ConfigArgs']] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None):
        """
        The set of arguments for constructing a Transfer resource.
        """
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "connection", connection)
        pulumi.set(__self__, "recipient_pubkey", recipient_pubkey)
        pulumi.set(__self__, "transaction_options", transaction_options)
        if allow_unfunded_recipient is not None:
            pulumi.set(__self__, "allow_unfunded_recipient", allow_unfunded_recipient)
        if runner_config is not None:
            pulumi.set(__self__, "runner_config", runner_config)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> pulumi.Input[_builtins.float]:
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "amount", value)

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Input['_ssh.ConnectionArgs']:
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: pulumi.Input['_ssh.ConnectionArgs']):
        pulumi.set(self, "connection", value)

    @_builtins.property
    @pulumi.getter(name="recipientPubkey")
    def recipient_pubkey(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "recipient_pubkey")

    @recipient_pubkey.setter
    def recipient_pubkey(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recipient_pubkey", value)

    @_builtins.property
    @pulumi.getter(name="transactionOptions")
    def transaction_options(self) -> pulumi.Input['_solana.TxnOptionsArgs']:
        return pulumi.get(self, "transaction_options")

    @transaction_options.setter
    def transaction_options(self, value: pulumi.Input['_solana.TxnOptionsArgs']):
        pulumi.set(self, "transaction_options", value)

    @_builtins.property
    @pulumi.getter(name="allowUnfundedRecipient")
    def allow_unfunded_recipient(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "allow_unfunded_recipient")

    @allow_unfunded_recipient.setter
    def allow_unfunded_recipient(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_unfunded_recipient", value)

    @_builtins.property
    @pulumi.getter(name="runnerConfig")
    def runner_config(self) -> Optional[pulumi.Input['_runner.ConfigArgs']]:
        return pulumi.get(self, "runner_config")

    @runner_config.setter
    def runner_config(self, value: Optional[pulumi.Input['_runner.ConfigArgs']]):
        pulumi.set(self, "runner_config", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "triggers", value)


@pulumi.type_token("svmkit:account:Transfer")
class Transfer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_unfunded_recipient: Optional[pulumi.Input[_builtins.bool]] = None,
                 amount: Optional[pulumi.Input[_builtins.float]] = None,
                 connection: Optional[pulumi.Input[Union['_ssh.ConnectionArgs', '_ssh.ConnectionArgsDict']]] = None,
                 recipient_pubkey: Optional[pulumi.Input[_builtins.str]] = None,
                 runner_config: Optional[pulumi.Input[Union['_runner.ConfigArgs', '_runner.ConfigArgsDict']]] = None,
                 transaction_options: Optional[pulumi.Input[Union['_solana.TxnOptionsArgs', '_solana.TxnOptionsArgsDict']]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 __props__=None):
        """
        Create a Transfer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransferArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Transfer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param TransferArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransferArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_unfunded_recipient: Optional[pulumi.Input[_builtins.bool]] = None,
                 amount: Optional[pulumi.Input[_builtins.float]] = None,
                 connection: Optional[pulumi.Input[Union['_ssh.ConnectionArgs', '_ssh.ConnectionArgsDict']]] = None,
                 recipient_pubkey: Optional[pulumi.Input[_builtins.str]] = None,
                 runner_config: Optional[pulumi.Input[Union['_runner.ConfigArgs', '_runner.ConfigArgsDict']]] = None,
                 transaction_options: Optional[pulumi.Input[Union['_solana.TxnOptionsArgs', '_solana.TxnOptionsArgsDict']]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransferArgs.__new__(TransferArgs)

            __props__.__dict__["allow_unfunded_recipient"] = allow_unfunded_recipient
            if amount is None and not opts.urn:
                raise TypeError("Missing required property 'amount'")
            __props__.__dict__["amount"] = amount
            if connection is None and not opts.urn:
                raise TypeError("Missing required property 'connection'")
            __props__.__dict__["connection"] = connection
            if recipient_pubkey is None and not opts.urn:
                raise TypeError("Missing required property 'recipient_pubkey'")
            __props__.__dict__["recipient_pubkey"] = recipient_pubkey
            __props__.__dict__["runner_config"] = runner_config
            if transaction_options is None and not opts.urn:
                raise TypeError("Missing required property 'transaction_options'")
            __props__.__dict__["transaction_options"] = transaction_options
            __props__.__dict__["triggers"] = triggers
        super(Transfer, __self__).__init__(
            'svmkit:account:Transfer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Transfer':
        """
        Get an existing Transfer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TransferArgs.__new__(TransferArgs)

        __props__.__dict__["allow_unfunded_recipient"] = None
        __props__.__dict__["amount"] = None
        __props__.__dict__["connection"] = None
        __props__.__dict__["recipient_pubkey"] = None
        __props__.__dict__["runner_config"] = None
        __props__.__dict__["transaction_options"] = None
        __props__.__dict__["triggers"] = None
        return Transfer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowUnfundedRecipient")
    def allow_unfunded_recipient(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "allow_unfunded_recipient")

    @_builtins.property
    @pulumi.getter
    def amount(self) -> pulumi.Output[_builtins.float]:
        return pulumi.get(self, "amount")

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Output['_ssh.outputs.Connection']:
        return pulumi.get(self, "connection")

    @_builtins.property
    @pulumi.getter(name="recipientPubkey")
    def recipient_pubkey(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "recipient_pubkey")

    @_builtins.property
    @pulumi.getter(name="runnerConfig")
    def runner_config(self) -> pulumi.Output[Optional['_runner.outputs.Config']]:
        return pulumi.get(self, "runner_config")

    @_builtins.property
    @pulumi.getter(name="transactionOptions")
    def transaction_options(self) -> pulumi.Output['_solana.outputs.TxnOptions']:
        return pulumi.get(self, "transaction_options")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Sequence[Any]]]:
        return pulumi.get(self, "triggers")

