# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import deb as _deb
from .. import runner as _runner
from .. import ssh as _ssh
from ._inputs import *

__all__ = ['FaucetArgs', 'Faucet']

@pulumi.input_type
class FaucetArgs:
    def __init__(__self__, *,
                 connection: pulumi.Input['_ssh.ConnectionArgs'],
                 flags: pulumi.Input['FaucetFlagsArgs'],
                 keypair: pulumi.Input[_builtins.str],
                 runner_config: Optional[pulumi.Input['_runner.ConfigArgs']] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Faucet resource.
        """
        pulumi.set(__self__, "connection", connection)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "keypair", keypair)
        if runner_config is not None:
            pulumi.set(__self__, "runner_config", runner_config)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Input['_ssh.ConnectionArgs']:
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: pulumi.Input['_ssh.ConnectionArgs']):
        pulumi.set(self, "connection", value)

    @_builtins.property
    @pulumi.getter
    def flags(self) -> pulumi.Input['FaucetFlagsArgs']:
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: pulumi.Input['FaucetFlagsArgs']):
        pulumi.set(self, "flags", value)

    @_builtins.property
    @pulumi.getter
    def keypair(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "keypair")

    @keypair.setter
    def keypair(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "keypair", value)

    @_builtins.property
    @pulumi.getter(name="runnerConfig")
    def runner_config(self) -> Optional[pulumi.Input['_runner.ConfigArgs']]:
        return pulumi.get(self, "runner_config")

    @runner_config.setter
    def runner_config(self, value: Optional[pulumi.Input['_runner.ConfigArgs']]):
        pulumi.set(self, "runner_config", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "triggers", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("svmkit:faucet:Faucet")
class Faucet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection: Optional[pulumi.Input[Union['_ssh.ConnectionArgs', '_ssh.ConnectionArgsDict']]] = None,
                 flags: Optional[pulumi.Input[Union['FaucetFlagsArgs', 'FaucetFlagsArgsDict']]] = None,
                 keypair: Optional[pulumi.Input[_builtins.str]] = None,
                 runner_config: Optional[pulumi.Input[Union['_runner.ConfigArgs', '_runner.ConfigArgsDict']]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Faucet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FaucetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Faucet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param FaucetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FaucetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection: Optional[pulumi.Input[Union['_ssh.ConnectionArgs', '_ssh.ConnectionArgsDict']]] = None,
                 flags: Optional[pulumi.Input[Union['FaucetFlagsArgs', 'FaucetFlagsArgsDict']]] = None,
                 keypair: Optional[pulumi.Input[_builtins.str]] = None,
                 runner_config: Optional[pulumi.Input[Union['_runner.ConfigArgs', '_runner.ConfigArgsDict']]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FaucetArgs.__new__(FaucetArgs)

            if connection is None and not opts.urn:
                raise TypeError("Missing required property 'connection'")
            __props__.__dict__["connection"] = connection
            if flags is None and not opts.urn:
                raise TypeError("Missing required property 'flags'")
            __props__.__dict__["flags"] = flags
            if keypair is None and not opts.urn:
                raise TypeError("Missing required property 'keypair'")
            __props__.__dict__["keypair"] = None if keypair is None else pulumi.Output.secret(keypair)
            __props__.__dict__["runner_config"] = runner_config
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["version"] = version
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["keypair"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Faucet, __self__).__init__(
            'svmkit:faucet:Faucet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Faucet':
        """
        Get an existing Faucet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FaucetArgs.__new__(FaucetArgs)

        __props__.__dict__["connection"] = None
        __props__.__dict__["flags"] = None
        __props__.__dict__["keypair"] = None
        __props__.__dict__["runner_config"] = None
        __props__.__dict__["triggers"] = None
        __props__.__dict__["version"] = None
        return Faucet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Output['_ssh.outputs.Connection']:
        return pulumi.get(self, "connection")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> pulumi.Output['outputs.FaucetFlags']:
        return pulumi.get(self, "flags")

    @_builtins.property
    @pulumi.getter
    def keypair(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "keypair")

    @_builtins.property
    @pulumi.getter(name="runnerConfig")
    def runner_config(self) -> pulumi.Output[Optional['_runner.outputs.Config']]:
        return pulumi.get(self, "runner_config")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Sequence[Any]]]:
        return pulumi.get(self, "triggers")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "version")

