# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import deb as _deb
from .. import deletion
from .. import runner as _runner
from .. import ssh as _ssh
from ._inputs import *

__all__ = ['SolanaArgs', 'Solana']

@pulumi.input_type
class SolanaArgs:
    def __init__(__self__, *,
                 connection: pulumi.Input['_ssh.ConnectionArgs'],
                 flags: pulumi.Input['GenesisFlagsArgs'],
                 primordial: pulumi.Input[Sequence[pulumi.Input['PrimordialAccountArgs']]],
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input['BootstrapAccountArgs']]]] = None,
                 deletion_policy: Optional[pulumi.Input['deletion.Policy']] = None,
                 ignore_changes_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 runner_config: Optional[pulumi.Input['_runner.ConfigArgs']] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Solana resource.
        """
        pulumi.set(__self__, "connection", connection)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "primordial", primordial)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if ignore_changes_on_update is not None:
            pulumi.set(__self__, "ignore_changes_on_update", ignore_changes_on_update)
        if runner_config is not None:
            pulumi.set(__self__, "runner_config", runner_config)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Input['_ssh.ConnectionArgs']:
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: pulumi.Input['_ssh.ConnectionArgs']):
        pulumi.set(self, "connection", value)

    @_builtins.property
    @pulumi.getter
    def flags(self) -> pulumi.Input['GenesisFlagsArgs']:
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: pulumi.Input['GenesisFlagsArgs']):
        pulumi.set(self, "flags", value)

    @_builtins.property
    @pulumi.getter
    def primordial(self) -> pulumi.Input[Sequence[pulumi.Input['PrimordialAccountArgs']]]:
        return pulumi.get(self, "primordial")

    @primordial.setter
    def primordial(self, value: pulumi.Input[Sequence[pulumi.Input['PrimordialAccountArgs']]]):
        pulumi.set(self, "primordial", value)

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BootstrapAccountArgs']]]]:
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BootstrapAccountArgs']]]]):
        pulumi.set(self, "accounts", value)

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input['deletion.Policy']]:
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input['deletion.Policy']]):
        pulumi.set(self, "deletion_policy", value)

    @_builtins.property
    @pulumi.getter(name="ignoreChangesOnUpdate")
    def ignore_changes_on_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ignore_changes_on_update")

    @ignore_changes_on_update.setter
    def ignore_changes_on_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_changes_on_update", value)

    @_builtins.property
    @pulumi.getter(name="runnerConfig")
    def runner_config(self) -> Optional[pulumi.Input['_runner.ConfigArgs']]:
        return pulumi.get(self, "runner_config")

    @runner_config.setter
    def runner_config(self, value: Optional[pulumi.Input['_runner.ConfigArgs']]):
        pulumi.set(self, "runner_config", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "triggers", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("svmkit:genesis:Solana")
class Solana(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BootstrapAccountArgs', 'BootstrapAccountArgsDict']]]]] = None,
                 connection: Optional[pulumi.Input[Union['_ssh.ConnectionArgs', '_ssh.ConnectionArgsDict']]] = None,
                 deletion_policy: Optional[pulumi.Input['deletion.Policy']] = None,
                 flags: Optional[pulumi.Input[Union['GenesisFlagsArgs', 'GenesisFlagsArgsDict']]] = None,
                 ignore_changes_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 primordial: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PrimordialAccountArgs', 'PrimordialAccountArgsDict']]]]] = None,
                 runner_config: Optional[pulumi.Input[Union['_runner.ConfigArgs', '_runner.ConfigArgsDict']]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Solana resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SolanaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Solana resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SolanaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SolanaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BootstrapAccountArgs', 'BootstrapAccountArgsDict']]]]] = None,
                 connection: Optional[pulumi.Input[Union['_ssh.ConnectionArgs', '_ssh.ConnectionArgsDict']]] = None,
                 deletion_policy: Optional[pulumi.Input['deletion.Policy']] = None,
                 flags: Optional[pulumi.Input[Union['GenesisFlagsArgs', 'GenesisFlagsArgsDict']]] = None,
                 ignore_changes_on_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 primordial: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PrimordialAccountArgs', 'PrimordialAccountArgsDict']]]]] = None,
                 runner_config: Optional[pulumi.Input[Union['_runner.ConfigArgs', '_runner.ConfigArgsDict']]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SolanaArgs.__new__(SolanaArgs)

            __props__.__dict__["accounts"] = accounts
            if connection is None and not opts.urn:
                raise TypeError("Missing required property 'connection'")
            __props__.__dict__["connection"] = connection
            __props__.__dict__["deletion_policy"] = deletion_policy
            if flags is None and not opts.urn:
                raise TypeError("Missing required property 'flags'")
            __props__.__dict__["flags"] = flags
            __props__.__dict__["ignore_changes_on_update"] = ignore_changes_on_update
            if primordial is None and not opts.urn:
                raise TypeError("Missing required property 'primordial'")
            __props__.__dict__["primordial"] = primordial
            __props__.__dict__["runner_config"] = runner_config
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["version"] = version
            __props__.__dict__["genesis_hash"] = None
        super(Solana, __self__).__init__(
            'svmkit:genesis:Solana',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Solana':
        """
        Get an existing Solana resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SolanaArgs.__new__(SolanaArgs)

        __props__.__dict__["accounts"] = None
        __props__.__dict__["connection"] = None
        __props__.__dict__["deletion_policy"] = None
        __props__.__dict__["flags"] = None
        __props__.__dict__["genesis_hash"] = None
        __props__.__dict__["ignore_changes_on_update"] = None
        __props__.__dict__["primordial"] = None
        __props__.__dict__["runner_config"] = None
        __props__.__dict__["triggers"] = None
        __props__.__dict__["version"] = None
        return Solana(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> pulumi.Output[Optional[Sequence['outputs.BootstrapAccount']]]:
        return pulumi.get(self, "accounts")

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Output['_ssh.outputs.Connection']:
        return pulumi.get(self, "connection")

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional['deletion.Policy']]:
        return pulumi.get(self, "deletion_policy")

    @_builtins.property
    @pulumi.getter
    def flags(self) -> pulumi.Output['outputs.GenesisFlags']:
        return pulumi.get(self, "flags")

    @_builtins.property
    @pulumi.getter(name="genesisHash")
    def genesis_hash(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "genesis_hash")

    @_builtins.property
    @pulumi.getter(name="ignoreChangesOnUpdate")
    def ignore_changes_on_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "ignore_changes_on_update")

    @_builtins.property
    @pulumi.getter
    def primordial(self) -> pulumi.Output[Sequence['outputs.PrimordialAccount']]:
        return pulumi.get(self, "primordial")

    @_builtins.property
    @pulumi.getter(name="runnerConfig")
    def runner_config(self) -> pulumi.Output[Optional['_runner.outputs.Config']]:
        return pulumi.get(self, "runner_config")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Sequence[Any]]]:
        return pulumi.get(self, "triggers")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "version")

