# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import apt as _apt
from .. import deb as _deb
from .. import runner as _runner
from .. import ssh as _ssh

__all__ = ['MachineArgs', 'Machine']

@pulumi.input_type
class MachineArgs:
    def __init__(__self__, *,
                 connection: pulumi.Input['_ssh.ConnectionArgs'],
                 apt_config: Optional[pulumi.Input['_apt.ConfigArgs']] = None,
                 runner_config: Optional[pulumi.Input['_runner.ConfigArgs']] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None):
        """
        The set of arguments for constructing a Machine resource.
        """
        pulumi.set(__self__, "connection", connection)
        if apt_config is not None:
            pulumi.set(__self__, "apt_config", apt_config)
        if runner_config is not None:
            pulumi.set(__self__, "runner_config", runner_config)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Input['_ssh.ConnectionArgs']:
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: pulumi.Input['_ssh.ConnectionArgs']):
        pulumi.set(self, "connection", value)

    @_builtins.property
    @pulumi.getter(name="aptConfig")
    def apt_config(self) -> Optional[pulumi.Input['_apt.ConfigArgs']]:
        return pulumi.get(self, "apt_config")

    @apt_config.setter
    def apt_config(self, value: Optional[pulumi.Input['_apt.ConfigArgs']]):
        pulumi.set(self, "apt_config", value)

    @_builtins.property
    @pulumi.getter(name="runnerConfig")
    def runner_config(self) -> Optional[pulumi.Input['_runner.ConfigArgs']]:
        return pulumi.get(self, "runner_config")

    @runner_config.setter
    def runner_config(self, value: Optional[pulumi.Input['_runner.ConfigArgs']]):
        pulumi.set(self, "runner_config", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "triggers", value)


@pulumi.type_token("svmkit:machine:Machine")
class Machine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apt_config: Optional[pulumi.Input[Union['_apt.ConfigArgs', '_apt.ConfigArgsDict']]] = None,
                 connection: Optional[pulumi.Input[Union['_ssh.ConnectionArgs', '_ssh.ConnectionArgsDict']]] = None,
                 runner_config: Optional[pulumi.Input[Union['_runner.ConfigArgs', '_runner.ConfigArgsDict']]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 __props__=None):
        """
        Create a Machine resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Machine resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apt_config: Optional[pulumi.Input[Union['_apt.ConfigArgs', '_apt.ConfigArgsDict']]] = None,
                 connection: Optional[pulumi.Input[Union['_ssh.ConnectionArgs', '_ssh.ConnectionArgsDict']]] = None,
                 runner_config: Optional[pulumi.Input[Union['_runner.ConfigArgs', '_runner.ConfigArgsDict']]] = None,
                 triggers: Optional[pulumi.Input[Sequence[Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MachineArgs.__new__(MachineArgs)

            __props__.__dict__["apt_config"] = apt_config
            if connection is None and not opts.urn:
                raise TypeError("Missing required property 'connection'")
            __props__.__dict__["connection"] = connection
            __props__.__dict__["runner_config"] = runner_config
            __props__.__dict__["triggers"] = triggers
        super(Machine, __self__).__init__(
            'svmkit:machine:Machine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Machine':
        """
        Get an existing Machine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MachineArgs.__new__(MachineArgs)

        __props__.__dict__["apt_config"] = None
        __props__.__dict__["connection"] = None
        __props__.__dict__["runner_config"] = None
        __props__.__dict__["triggers"] = None
        return Machine(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aptConfig")
    def apt_config(self) -> pulumi.Output[Optional['_apt.outputs.Config']]:
        return pulumi.get(self, "apt_config")

    @_builtins.property
    @pulumi.getter
    def connection(self) -> pulumi.Output['_ssh.outputs.Connection']:
        return pulumi.get(self, "connection")

    @_builtins.property
    @pulumi.getter(name="runnerConfig")
    def runner_config(self) -> pulumi.Output[Optional['_runner.outputs.Config']]:
        return pulumi.get(self, "runner_config")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Sequence[Any]]]:
        return pulumi.get(self, "triggers")

