from qubx.core.basics import AssetType, Instrument, MarketType

SAMPLE_INSTRUMENTS = [
    Instrument(
        symbol="EURUSD",
        asset_type=AssetType.FX,
        market_type=MarketType.SPOT,
        exchange="DUKAS",
        base="EUR",
        quote="USD",
        settle="USD",
        exchange_symbol="EURUSD",
        tick_size=0.00001,
        lot_size=1000,
        min_size=1000,
        min_notional=0.0,
        initial_margin=0.0,
        maint_margin=0.0,
        liquidation_fee=0.0,
        contract_size=1.0,
    ),
    Instrument(
        symbol="GBPUSD",
        asset_type=AssetType.FX,
        market_type=MarketType.SPOT,
        exchange="DUKAS",
        base="GBP",
        quote="USD",
        settle="USD",
        exchange_symbol="GBPUSD",
        tick_size=0.00001,
        lot_size=1000,
        min_size=1000,
        min_notional=0.0,
        initial_margin=0.0,
        maint_margin=0.0,
        liquidation_fee=0.0,
        contract_size=1.0,
    ),
    Instrument(
        symbol="USDJPY",
        asset_type=AssetType.FX,
        market_type=MarketType.SPOT,
        exchange="DUKAS",
        base="USD",
        quote="JPY",
        settle="USD",
        exchange_symbol="USDJPY",
        tick_size=0.001,
        lot_size=1000,
        min_size=1000,
        min_notional=0.0,
        initial_margin=0.0,
        maint_margin=0.0,
        liquidation_fee=0.0,
        contract_size=1.0,
    ),
    Instrument(
        symbol="USDCAD",
        asset_type=AssetType.FX,
        market_type=MarketType.SPOT,
        exchange="DUKAS",
        base="USD",
        quote="CAD",
        settle="USD",
        exchange_symbol="USDCAD",
        tick_size=0.00001,
        lot_size=1000,
        min_size=1000,
        min_notional=0.0,
        initial_margin=0.0,
        maint_margin=0.0,
        liquidation_fee=0.0,
        contract_size=1.0,
    ),
    Instrument(
        symbol="AUDUSD",
        asset_type=AssetType.FX,
        market_type=MarketType.SPOT,
        exchange="DUKAS",
        base="AUD",
        quote="USD",
        settle="USD",
        exchange_symbol="AUDUSD",
        tick_size=0.00001,
        lot_size=1000,
        min_size=1000,
        min_notional=0.0,
        initial_margin=0.0,
        maint_margin=0.0,
        liquidation_fee=0.0,
        contract_size=1.0,
    ),
    Instrument(
        symbol="USDPLN",
        asset_type=AssetType.FX,
        market_type=MarketType.SPOT,
        exchange="DUKAS",
        base="USD",
        quote="PLN",
        settle="USD",
        exchange_symbol="USDPLN",
        tick_size=0.00001,
        lot_size=1000,
        min_size=1000,
        min_notional=0.0,
        initial_margin=0.0,
        maint_margin=0.0,
        liquidation_fee=0.0,
        contract_size=1.0,
    ),
    Instrument(
        symbol="EURGBP",
        asset_type=AssetType.FX,
        market_type=MarketType.SPOT,
        exchange="DUKAS",
        base="EUR",
        quote="GBP",
        settle="USD",
        exchange_symbol="EURGBP",
        tick_size=0.00001,
        lot_size=1000,
        min_size=1000,
        min_notional=0.0,
        initial_margin=0.0,
        maint_margin=0.0,
        liquidation_fee=0.0,
        contract_size=1.0,
    ),
]
