![Logo](https://bitbucket.org/rfg_lab/junkie/raw/64d3877b39417d70e6dc0cf18814495b4d9a57b7/docs/junkie_logo_100x100.png)
[![GPLv3 License](https://img.shields.io/badge/License-GPL%20v3-yellow.svg)](https://opensource.org/licenses/GPL-3.0)

# [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) (a JUpyter NotebooK Image Explorer)

## Installing [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/)

We recommend that you install [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) using [uv](https://github.com/astral-sh/uv):

    $ uv pip install junkie-rfglab

[JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) can also be installed using [pip](https://pip.pypa.io/en):  

    $ python3 -m pip install --no-cache-dir -U junkie-rfglab

We do most of the development and testing of [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) in [Jupyter Lab](https://jupyter.org/install), so we recommend using [Jupyter Lab](https://jupyter.org/install). 

### A note on the Python interpreter

[JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) requires that you
have [Python 3.10 or above](https://www.python.org/downloads/) installed.

## Using [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/)

[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/git/https%3A%2F%2Fbitbucket.org%2Frfg_lab%2Fjunkie%2F/HEAD?urlpath=%2Fdoc%2Ftree%2Fdocs%2Fusing_junkie.ipynb)

To start, open a notebook and import [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/):

    from junkie import junkie

There are a few ways to open an image with [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/):

- You can open an image with some other package (e.g. scikit-image, opencv, PIL, etc.) and invoke [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) with a [numpy ndarray](https://numpy.org/doc/stable/reference/generated/numpy.ndarray.html) as the parameter:

        import skimage.io as skio
        astack = skio.imread('cells_movie.tif')
        myim = junkie(astack)

- You can also specifiy the path to the image that you want to open:

        myim = junkie('cells_movie.tif')

- Or you can indicate a folder that contains an image sequence:

        myim = junkie('./slices')

- If there are image channels split into different files, you can also specify a tuple of strings to distinguish which files in the folder belong to which channel:

        myim = junkie('./slices', ('488', '561'))

- You can use a list of numpy arrays and/or paths to concatenate sideways (i.e. display side-by-side, but all the images must have the same dimensions!!):

        myim = junkie([astack, 'cells_movie.tif'])

- You can combine the list input with the [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) class method *read_image* to display image channels side-by-side:

        myim = junkie([*junkie.read_image('./slices', ('488', '561'))])

[JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) has a couple of additional parameters:

- *cmap* (str) indicates the color map used to display the image. It defaults to *'gray'*. Check [here](https://matplotlib.org/stable/tutorials/colors/colormaps.html) for a list of color maps.

        myim = junkie('cells_movie.tif', cmap='viridis')

- *figsize* (Tuple[int, int]) specifies the image panel size. The image aspect ratio is maintained. It defaults to *(4, 4)*.

        myim = junkie('cells_movie.tif', figsize=(8, 8)

[JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) provides access to the standard [matplotlib](https://matplotlib.org/) toolbar, and also includes a second toolbar with additional functionality:

|icon|function|
|----------------------------------------|------------------------|
|![refresh_icon](https://bitbucket.org/rfg_lab/junkie/raw/64d3877b39417d70e6dc0cf18814495b4d9a57b7/docs/refresh_icon.png)|rotate 90&deg; clockwise
|![refresh_icon](https://bitbucket.org/rfg_lab/junkie/raw/64d3877b39417d70e6dc0cf18814495b4d9a57b7/docs/arrows_h_icon.png)|flip horizontally|
|![refresh_icon](https://bitbucket.org/rfg_lab/junkie/raw/64d3877b39417d70e6dc0cf18814495b4d9a57b7/docs/arrows_v_icon.png)|flip vertically|
|![refresh_icon](https://bitbucket.org/rfg_lab/junkie/raw/64d3877b39417d70e6dc0cf18814495b4d9a57b7/docs/shield_icon.png)|invert color map|
|![refresh_icon](https://bitbucket.org/rfg_lab/junkie/raw/64d3877b39417d70e6dc0cf18814495b4d9a57b7/docs/area_chart_icon.png)|hide/show axes|
|![refresh_icon](https://bitbucket.org/rfg_lab/junkie/raw/64d3877b39417d70e6dc0cf18814495b4d9a57b7/docs/fast_forward_icon.png)|continuous/discrete update|

## [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) today

As we develop and improve [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/), there may be small changes to the user interface. This is how [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) looks as of today:

![JuNkIE today](https://bitbucket.org/rfg_lab/junkie/raw/64d3877b39417d70e6dc0cf18814495b4d9a57b7/docs/junkie_today.gif)

## Citing [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/)

If you use [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/), please cite this repository. We are working on the paper!

## Adding functionality onto [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/)

If you would like to extend [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/), please make contributions to this repository. You can also check out [JuNkIE-picasso](https://bitbucket.org/raymond_hawkins_utor/junkie_picasso/src/master/), a [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/) fork that allows you to define arbitrary image processing pipelines and integrate them into [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/).

## Sponsors

We are grateful for the generous support from the following agencies and institutions, which contribute to the
development and maintenance of [JuNkIE](https://bitbucket.org/rfg_lab/junkie/src/master/):

![Sponsors](https://bitbucket.org/rfg_lab/junkie/raw/64d3877b39417d70e6dc0cf18814495b4d9a57b7/docs/sponsors.png)