# This file was auto-generated by Fern from our API Definition.

from .problem_details import ProblemDetails
import typing
from .problem_type import ProblemType
import datetime as dt
import pydantic
from .problem_cause import ProblemCause
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Problem(ProblemDetails):
    """
    Generic base type for problems in Synqly. This object carries both machine-readable data as well as information intended for display purposes.
    """

    type: typing.Optional[ProblemType] = None
    occurred_at: dt.datetime = pydantic.Field()
    """
    The date and time the problem occurred.
    """

    status: int = pydantic.Field()
    """
    The HTTP status code of the problem. Matches the HTTP response code sent by the server.
    """

    instance: str = pydantic.Field()
    """
    A URI reference that identifies the specific occurrence of the problem. It may or may not yield further information if dereferenced.
    """

    cause: typing.Optional[typing.List[ProblemCause]] = pydantic.Field(default=None)
    """
    A list of the root cause(s) for this problem occurrence. Includes at minimum one root cause, and is otherwise an unordered list of causes.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
