# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from .problematic_parameter import ProblematicParameter
import pydantic
from .resource_reference import ResourceReference
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ProblemContext(UncheckedBaseModel):
    parameter: typing.Optional[ProblematicParameter] = pydantic.Field(default=None)
    """
    If the problem is related to a `query`, `header`, `path` or `body` parameter, this field will describe the problematic parameter and where to find it.
    """

    resources: typing.Optional[typing.List[ResourceReference]] = None
    raw_error: typing.Optional[str] = pydantic.Field(default=None)
    """
    If available this represents the underlying raw error, for example an error response from a Provider.
    """

    provider_details: typing.Optional[typing.Dict[str, str]] = pydantic.Field(
        default=None
    )
    """
    If available this represents the underlying details from the provider. May include the error message, status code, and other details.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
