# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from .notification_id import NotificationId
import pydantic
import typing
from ...ticketing.types.priority import Priority
from .notification_status import NotificationStatus
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Notification(Base):
    """
    Notification object
    """

    id: NotificationId
    summary: str = pydantic.Field()
    """
    Notification summary.
    """

    priority: typing.Optional[Priority] = pydantic.Field(default=None)
    """
    Notification priority
    """

    notification_status: typing.Optional[NotificationStatus] = pydantic.Field(
        default=None
    )
    """
    Notification status
    """

    project: typing.Optional[str] = pydantic.Field(default=None)
    """
    Notification project
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The current status of the notification.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Notification description.
    """

    issue_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The notification's type.
    """

    creator: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user who created this notification.
    """

    assignee: typing.Optional[str] = pydantic.Field(default=None)
    """
    Who notification is assigned to.
    """

    contact: typing.Optional[str] = pydantic.Field(default=None)
    """
    The notification contact information.
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Associate tags with Notification
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
