# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Group(UncheckedBaseModel):
    """
    The Group object represents a collection or association of entities, such as users, policies, or devices. It serves as a logical grouping mechanism to organize and manage entities with similar characteristics or permissions within a system or organization.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The group description.
    """

    domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The domain where the group is defined. For example: the LDAP or Active Directory domain.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The group name.
    """

    privileges: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The group privileges.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the group or account.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the group. For example, for Windows events this is the security identifier (SID) of the group.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
