# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Display(UncheckedBaseModel):
    """
    The Display object contains information about the physical or virtual display connected to a computer system.
    """

    color_depth: typing.Optional[int] = pydantic.Field(default=None)
    """
    The numeric color depth.
    """

    physical_height: typing.Optional[int] = pydantic.Field(default=None)
    """
    The numeric physical height of display.
    """

    physical_orientation: typing.Optional[int] = pydantic.Field(default=None)
    """
    The numeric physical orientation of display.
    """

    physical_width: typing.Optional[int] = pydantic.Field(default=None)
    """
    The numeric physical width of display.
    """

    scale_factor: typing.Optional[int] = pydantic.Field(default=None)
    """
    The numeric scale factor of display.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
