# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Tactic(UncheckedBaseModel):
    """
    The MITRE ATT&CK® Tactic object describes the tactic ID and/or name that is associated to an attack, as defined by <a target='_blank' href='https://attack.mitre.org/wiki/ATT&CK_Matrix'>ATT&CK® Matrix</a>.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tactic name that is associated with the attack technique, as defined by <a target='_blank' href='https://attack.mitre.org/wiki/ATT&CK_Matrix'>ATT&CK® Matrix</a>. For example: <code>Reconnaissance</code>.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The versioned permalink of the attack tactic, as defined by <a target='_blank' href='https://attack.mitre.org/wiki/ATT&CK_Matrix'>ATT&CK® Matrix</a>. For example: <code>https://attack.mitre.org/versions/v14/tactics/TA0043/</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tactic ID that is associated with the attack technique, as defined by <a target='_blank' href='https://attack.mitre.org/wiki/ATT&CK_Matrix'>ATT&CK® Matrix</a>. For example: <code>TA0043</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
