# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .digital_signature_algorithm_id import DigitalSignatureAlgorithmId
from .certificate import Certificate
from ...base.types.timestamp import Timestamp
import datetime as dt
from .fingerprint import Fingerprint
from .digital_signature_state_id import DigitalSignatureStateId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class DigitalSignature(UncheckedBaseModel):
    """
    The Digital Signature object contains information about the cryptographic mechanism used to verify the authenticity, integrity, and origin of the file or application.
    """

    algorithm: typing.Optional[str] = pydantic.Field(default=None)
    """
    The digital signature algorithm used to create the signature, normalized to the caption of 'algorithm_id'. In the case of 'Other', it is defined by the event source.
    """

    algorithm_id: DigitalSignatureAlgorithmId = pydantic.Field()
    """
    The identifier of the normalized digital signature algorithm.
    """

    certificate: typing.Optional[Certificate] = pydantic.Field(default=None)
    """
    The certificate object containing information about the digital certificate.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the digital signature was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the digital signature was created.
    """

    developer_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The developer ID on the certificate that signed the file.
    """

    digest: typing.Optional[Fingerprint] = pydantic.Field(default=None)
    """
    The message digest attribute contains the fixed length message hash representation and the corresponding hashing algorithm information.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    The digital signature state defines the signature state, normalized to the caption of 'state_id'. In the case of 'Other', it is defined by the event source.
    """

    state_id: typing.Optional[DigitalSignatureStateId] = pydantic.Field(default=None)
    """
    The normalized identifier of the signature state.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
