# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .meeting_attendee import MeetingAttendee
import pydantic
from ...base.types.timestamp import Timestamp
import datetime as dt
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Meeting(UncheckedBaseModel):
    """
    The Meeting object encompasses information relating to a meeting, such as might be present in typical office calendar software like Teams, Outlook, Google Calendar, etc.
    """

    attendees: typing.Optional[typing.List[MeetingAttendee]] = pydantic.Field(
        default=None
    )
    """
    Actors who are attendees of the meeting.
    """

    end_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    Time at which the meeting is scheduled to end.
    """

    end_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time at which the meeting is scheduled to end.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The meeting's display name.
    """

    start_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    Time at which the meeting is scheduled to begin.
    """

    start_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Time at which the meeting is scheduled to begin.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique ID associated with the meeting.
    """

    urls: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    URLs associated with the meeting, e.g. video conference links.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
