# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .actor import Actor
import pydantic
from .device import Device
from ...base.types.timestamp import Timestamp
import datetime as dt
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class MeetingAttendee(UncheckedBaseModel):
    """
    The Meeting Attendee object encompasses information related to a meeting attendee.
    """

    actor: typing.Optional[Actor] = pydantic.Field(default=None)
    """
    The actor corresponding to the entity joining the meeting.
    """

    device: typing.Optional[Device] = pydantic.Field(default=None)
    """
    Information about the attendee's device.
    """

    invited_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    When the actor was invited to the meeting.
    """

    invited_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the actor was invited to the meeting.
    """

    inviter: typing.Optional[Actor] = pydantic.Field(default=None)
    """
    The actor who invited the attendee to the meeting.
    """

    join_times: typing.Optional[typing.List[Timestamp]] = pydantic.Field(default=None)
    """
    Time(s) at which the attendee joined the meeting.
    """

    join_times_dt: typing.Optional[typing.List[dt.datetime]] = pydantic.Field(
        default=None
    )
    """
    Time(s) at which the attendee joined the meeting.
    """

    leave_times: typing.Optional[typing.List[Timestamp]] = pydantic.Field(default=None)
    """
    Time(s) at which the attendee left the meeting.
    """

    leave_times_dt: typing.Optional[typing.List[dt.datetime]] = pydantic.Field(
        default=None
    )
    """
    Time(s) at which the attendee left the meeting.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
