# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .remediation import Remediation
from .rule import Rule
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class CisBenchmarkResult(UncheckedBaseModel):
    """
    The CIS Benchmark Result object contains information as defined by the Center for Internet Security (<a target='_blank' href='https://www.cisecurity.org/cis-benchmarks/'>CIS</a>) benchmark result. CIS Benchmarks are a collection of best practices for securely configuring IT systems, software, networks, and cloud infrastructure.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The CIS benchmark description.
    """

    name: str = pydantic.Field()
    """
    The CIS benchmark name.
    """

    remediation: typing.Optional[Remediation] = pydantic.Field(default=None)
    """
    Describes the recommended remediation steps to address identified issue(s).
    """

    rule: typing.Optional[Rule] = pydantic.Field(default=None)
    """
    The CIS benchmark rule.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
