# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Rule(UncheckedBaseModel):
    """
    The Rule object describes characteristics of a rule associated with a policy or an event.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rule category.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the rule that generated the event.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the rule that generated the event.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rule type.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the rule that generated the event.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rule version. For example: <code>1.1</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
