# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .analytic import Analytic
import pydantic
from .attack import Attack
from ...base.types.timestamp import Timestamp
import datetime as dt
from .kill_chain_phase import KillChainPhase
from .related_event import RelatedEvent
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class FindingInfo(UncheckedBaseModel):
    """
    The Finding Information object describes metadata related to a security finding generated by a security tool or system.
    """

    analytic: typing.Optional[Analytic] = pydantic.Field(default=None)
    """
    The analytic technique used to analyze and derive insights from the data or information that led to the finding or conclusion.
    """

    attacks: typing.Optional[typing.List[Attack]] = pydantic.Field(default=None)
    """
    The <a target='_blank' href='https://attack.mitre.org'>MITRE ATT&CK®</a> technique and associated tactics related to the finding.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was created.
    """

    data_sources: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of data sources utilized in generation of the finding.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the reported finding.
    """

    first_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was first observed. e.g. The time when a vulnerability was first observed. <p>It can differ from the <code>created_time</code> timestamp, which reflects the time this finding was created.</p>
    """

    first_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was first observed. e.g. The time when a vulnerability was first observed. <p>It can differ from the <code>created_time</code> timestamp, which reflects the time this finding was created.</p>
    """

    kill_chain: typing.Optional[typing.List[KillChainPhase]] = pydantic.Field(
        default=None
    )
    """
    The <a target='_blank' href='https://www.lockheedmartin.com/en-us/capabilities/cyber/cyber-kill-chain.html'>Cyber Kill Chain®</a> provides a detailed description of each phase and its associated activities within the broader context of a cyber attack.
    """

    last_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was most recently observed. e.g. The time when a vulnerability was most recently observed. <p>It can differ from the <code>modified_time</code> timestamp, which reflects the time this finding was last modified.</p>
    """

    last_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was most recently observed. e.g. The time when a vulnerability was most recently observed. <p>It can differ from the <code>modified_time</code> timestamp, which reflects the time this finding was last modified.</p>
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was last modified.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was last modified.
    """

    product_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the product that reported the finding.
    """

    related_analytics: typing.Optional[typing.List[Analytic]] = pydantic.Field(
        default=None
    )
    """
    Other analytics related to this finding.
    """

    related_events: typing.Optional[typing.List[RelatedEvent]] = pydantic.Field(
        default=None
    )
    """
    Describes events and/or other findings related to the finding as identified by the security product.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The URL pointing to the source of the finding.
    """

    title: str = pydantic.Field()
    """
    A title or a brief phrase summarizing the reported finding.
    """

    types: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    One or more types of the reported finding.
    """

    uid: str = pydantic.Field()
    """
    The unique identifier of the reported finding.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
