# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.hostname import Hostname
from .dns_query_opcode_id import DnsQueryOpcodeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class DnsQuery(UncheckedBaseModel):
    """
    The DNS query object represents a specific request made to the Domain Name System (DNS) to retrieve information about a domain or perform a DNS operation. This object encapsulates the necessary attributes and methods to construct and send DNS queries, specify the query type (e.g., A, AAAA, MX). Defined by D3FEND <a target='_blank' href='https://d3fend.mitre.org/dao/artifact/d3f:DNSLookup/'>d3f:DNSLookup</a>.
    """

    class_: typing.Optional[str] = pydantic.Field(alias="class", default=None)
    """
    The class of resource records being queried. See <a target='_blank' href='https://www.rfc-editor.org/rfc/rfc1035.txt'>RFC1035</a>. For example: <code>IN</code>.
    """

    hostname: Hostname = pydantic.Field()
    """
    The hostname or domain being queried. For example: <code>www.example.com</code>
    """

    opcode: typing.Optional[str] = pydantic.Field(default=None)
    """
    The DNS opcode specifies the type of the query message.
    """

    opcode_id: typing.Optional[DnsQueryOpcodeId] = pydantic.Field(default=None)
    """
    The DNS opcode ID specifies the normalized query message type as defined in <a target='_blank' href='https://www.rfc-editor.org/rfc/rfc5395.html'>RFC-5395</a>.
    """

    packet_uid: typing.Optional[int] = pydantic.Field(default=None)
    """
    The DNS packet identifier assigned by the program that generated the query. The identifier is copied to the response.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of resource records being queried. See <a target='_blank' href='https://www.rfc-editor.org/rfc/rfc1035.txt'>RFC1035</a>. For example: A, AAAA, CNAME, MX, and NS.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
