# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .affected_code import AffectedCode
import pydantic
from .affected_package import AffectedPackage
from .cve import Cve
from .cwe import Cwe
from ...base.types.timestamp import Timestamp
import datetime as dt
from .kb_article import KbArticle
from .package import Package
from .remediation import Remediation
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Vulnerability(UncheckedBaseModel):
    """
    The vulnerability is an unintended characteristic of a computing component or system configuration that multiplies the risk of an adverse event or a loss occurring either due to accidental exposure, deliberate attack, or conflict with new system components.
    """

    affected_code: typing.Optional[typing.List[AffectedCode]] = pydantic.Field(
        default=None
    )
    """
    List of Affected Code objects that describe details about code blocks identified as vulnerable.
    """

    affected_packages: typing.Optional[typing.List[AffectedPackage]] = pydantic.Field(
        default=None
    )
    """
    List of software packages identified as affected by a vulnerability/vulnerabilities.
    """

    cve: typing.Optional[Cve] = pydantic.Field(default=None)
    """
    The Common Vulnerabilities and Exposures (<a target='_blank' href='https://cve.mitre.org/'>CVE</a>).
    """

    cwe: typing.Optional[Cwe] = pydantic.Field(default=None)
    """
    The CWE object represents a weakness in a software system that can be exploited by a threat actor to perform an attack. The CWE object is based on the <a target='_blank' href='https://cwe.mitre.org/'>Common Weakness Enumeration (CWE)</a> catalog.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the vulnerability.
    """

    first_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the vulnerability was first observed.
    """

    first_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the vulnerability was first observed.
    """

    fix_available: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if a fix is available for the reported vulnerability.
    """

    is_exploit_available: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if an exploit or a PoC (proof-of-concept) is available for the reported vulnerability.
    """

    is_fix_available: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if a fix is available for the reported vulnerability.
    """

    kb_article_list: typing.Optional[typing.List[KbArticle]] = pydantic.Field(
        default=None
    )
    """
    A list of KB articles or patches related to an endpoint. A KB Article contains metadata that describes the patch or an update.
    """

    kb_articles: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The KB article/s related to the entity. A KB Article contains metadata that describes the patch or an update.
    """

    last_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the vulnerability was most recently observed.
    """

    last_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the vulnerability was most recently observed.
    """

    packages: typing.Optional[typing.List[Package]] = pydantic.Field(default=None)
    """
    List of vulnerable packages as identified by the security product
    """

    references: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of reference URLs with additional information about the vulnerability.
    """

    related_vulnerabilities: typing.Optional[typing.List[str]] = pydantic.Field(
        default=None
    )
    """
    List of vulnerabilities that are related to this vulnerability.
    """

    remediation: typing.Optional[Remediation] = pydantic.Field(default=None)
    """
    The remediation recommendations on how to mitigate the identified vulnerability.
    """

    severity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The vendor assigned severity of the vulnerability.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A title or a brief phrase summarizing the discovered vulnerability.
    """

    vendor_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the vendor that identified the vulnerability.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
