# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.timestamp import Timestamp
import datetime as dt
from .file import File
from .job_run_state_id import JobRunStateId
from .user import User
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Job(UncheckedBaseModel):
    """
    The Job object provides information about a scheduled job or task, including its name, command line, and state. It encompasses attributes that describe the properties and status of the scheduled job.
    """

    cmd_line: typing.Optional[str] = pydantic.Field(default=None)
    """
    The job command line.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the job was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the job was created.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the job.
    """

    file: File = pydantic.Field()
    """
    The file that pertains to the job.
    """

    last_run_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the job was last run.
    """

    last_run_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the job was last run.
    """

    name: str = pydantic.Field()
    """
    The name of the job.
    """

    next_run_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the job will next be run.
    """

    next_run_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the job will next be run.
    """

    run_state: typing.Optional[str] = pydantic.Field(default=None)
    """
    The run state of the job.
    """

    run_state_id: typing.Optional[JobRunStateId] = pydantic.Field(default=None)
    """
    The run state ID of the job.
    """

    user: typing.Optional[User] = pydantic.Field(default=None)
    """
    The user that created the job.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
