# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .tls_extension_type_id import TlsExtensionTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class TlsExtension(UncheckedBaseModel):
    """
    The TLS Extension object describes additional attributes that extend the base Transport Layer Security (TLS) object.
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    The data contains information specific to the particular extension type.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The TLS extension type. For example: <code>Server Name</code>.
    """

    type_id: TlsExtensionTypeId = pydantic.Field()
    """
    The TLS extension type identifier. See <a target='_blank' href='https://datatracker.ietf.org/doc/html/rfc8446#page-35'>The Transport Layer Security (TLS) extension page</a>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
