# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Feature(UncheckedBaseModel):
    """
    The Feature object provides information about the software product feature that generated a specific event. It encompasses details related to the capabilities, components, user interface (UI) design, and performance upgrades associated with the feature.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the feature.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the feature.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the feature.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
