# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .object import Object
from .analytic_type_id import AnalyticTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Analytic(UncheckedBaseModel):
    """
    The Analytic object contains details about the analytic technique used to analyze and derive insights from the data or information that led to the creation of a finding or conclusion.
    """

    algorithm: typing.Optional[str] = pydantic.Field(default=None)
    """
    The algorithm used by the underlying analytic to generate the finding.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The analytic category.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the analytic that generated the finding.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the analytic that generated the finding.
    """

    related_analytics: typing.Optional[typing.List[Object]] = pydantic.Field(
        default=None
    )
    """
    Other analytics related to this analytic.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The analytic type.
    """

    type_id: AnalyticTypeId = pydantic.Field()
    """
    The analytic type ID.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the analytic that generated the finding.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The analytic version. For example: <code>1.1</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
