# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .advisory import Advisory
import pydantic
from .affected_code import AffectedCode
from .affected_package import AffectedPackage
from .cve import Cve
from .cwe import Cwe
from ...base.types.timestamp import Timestamp
import datetime as dt
from ...base.types.url_string import UrlString
from .vulnerability_fix_coverage_id import VulnerabilityFixCoverageId
from .kb_article import KbArticle
from .package import Package
from .remediation import Remediation
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Vulnerability(UncheckedBaseModel):
    """
    The vulnerability is an unintended characteristic of a computing component or system configuration that multiplies the risk of an adverse event or a loss occurring either due to accidental exposure, deliberate attack, or conflict with new system components.
    """

    advisory: typing.Optional[Advisory] = pydantic.Field(default=None)
    """
    Detail about the security advisory, that is used to publicly disclose cybersecurity vulnerabilities by a vendor.
    """

    affected_code: typing.Optional[typing.List[AffectedCode]] = pydantic.Field(
        default=None
    )
    """
    List of Affected Code objects that describe details about code blocks identified as vulnerable.
    """

    affected_packages: typing.Optional[typing.List[AffectedPackage]] = pydantic.Field(
        default=None
    )
    """
    List of software packages identified as affected by a vulnerability/vulnerabilities.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The category of a vulnerability or weakness, as reported by the source tool, such as <code>Container Security</code> or <code>Open Source Security</code>.
    """

    cve: typing.Optional[Cve] = pydantic.Field(default=None)
    """
    Describes the Common Vulnerabilities and Exposures <a target='_blank' href='https://cve.mitre.org/'>(CVE)</a> details related to the vulnerability.
    """

    cwe: typing.Optional[Cwe] = pydantic.Field(default=None)
    """
    Describes the Common Weakness Enumeration <a target='_blank' href='https://cwe.mitre.org/'>(CWE)</a> details related to the vulnerability.
    """

    dependency_chain: typing.Optional[str] = pydantic.Field(default=None)
    """
    Information about the chain of dependencies related to the issue as reported by an Application Security or Vulnerability Management tool. E.g., <code>serverless-offline -> @serverless/utils -> memoizee -> es5-ext</code>.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the vulnerability.
    """

    exploit_last_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the exploit was most recently observed.
    """

    exploit_last_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(
        default=None
    )
    """
    The time when the exploit was most recently observed.
    """

    exploit_ref_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The URL of the exploit code or Proof-of-Concept (PoC).
    """

    exploit_requirement: typing.Optional[str] = pydantic.Field(default=None)
    """
    The requirement description related to any constraints around exploit execution.
    """

    exploit_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The categorization or type of Exploit. E.g., <code>Network</code> or <code>Physical</code>.
    """

    first_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the vulnerability was first observed.
    """

    first_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the vulnerability was first observed.
    """

    fix_available: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if a fix is available for the reported vulnerability.
    """

    fix_coverage: typing.Optional[str] = pydantic.Field(default=None)
    """
    The fix coverage, normalized to the caption of the <code>fix_coverage_id</code> value.
    """

    fix_coverage_id: typing.Optional[VulnerabilityFixCoverageId] = pydantic.Field(
        default=None
    )
    """
    The normalized identifier for fix coverage, applicable to this vulnerability. Typically useful, when there are multiple affected packages but only a subset have available fixes.
    """

    is_exploit_available: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if an exploit or a PoC (proof-of-concept) is available for the reported vulnerability.
    """

    is_fix_available: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates if a fix is available for the reported vulnerability.
    """

    kb_article_list: typing.Optional[typing.List[KbArticle]] = pydantic.Field(
        default=None
    )
    """
    A list of KB articles or patches related to an endpoint. A KB Article contains metadata that describes the patch or an update.
    """

    kb_articles: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The KB article/s related to the entity. A KB Article contains metadata that describes the patch or an update.
    """

    last_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the vulnerability was most recently observed.
    """

    last_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the vulnerability was most recently observed.
    """

    packages: typing.Optional[typing.List[Package]] = pydantic.Field(default=None)
    """
    List of vulnerable packages as identified by the security product
    """

    references: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of reference URLs with additional information about the vulnerability.
    """

    related_vulnerabilities: typing.Optional[typing.List[str]] = pydantic.Field(
        default=None
    )
    """
    List of vulnerability IDs (e.g. CVE ID) that are related to this vulnerability.
    """

    remediation: typing.Optional[Remediation] = pydantic.Field(default=None)
    """
    The remediation recommendations on how to mitigate the identified vulnerability.
    """

    severity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The vendor assigned severity of the vulnerability.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A title or a brief phrase summarizing the discovered vulnerability.
    """

    vendor_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the vendor that identified the vulnerability.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
