# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class KeyValueObject(UncheckedBaseModel):
    """
    A generic object allowing to define a <code>{key:value}</code> pair.
    """

    name: str = pydantic.Field()
    """
    The name of the key.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The value associated to the key.
    """

    values: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Optional, the values associated to the key. You can populate this attribute, when you have multiple values for the same key.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
