# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.timestamp import Timestamp
import datetime as dt
from ...base.types.process_name import ProcessName
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class ProcessEntity(UncheckedBaseModel):
    """
    The Process Entity object provides critical fields for referencing a process.
    """

    cmd_line: typing.Optional[str] = pydantic.Field(default=None)
    """
    The full command line used to launch an application, service, process, or job. For example: <code>ssh user@10.0.0.10</code>. If the command line is unavailable or missing, the empty string <code>''</code> is to be used.
    """

    cpid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique process identifier that can be assigned deterministically by multiple system data producers.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the process was created/started.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the process was created/started.
    """

    name: typing.Optional[ProcessName] = pydantic.Field(default=None)
    """
    The friendly name of the process, for example: <code>Notepad++</code>.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The process file path.
    """

    pid: typing.Optional[int] = pydantic.Field(default=None)
    """
    The process identifier, as reported by the operating system. Process ID (PID) is a number used by the operating system to uniquely identify an active process.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for this process assigned by the producer (tool). Facilitates correlation of a process event with other events for that process.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
