# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .timespan import Timespan
import pydantic
from ...base.types.timestamp import Timestamp
import datetime as dt
from .kb_article_install_state_id import KbArticleInstallStateId
from .os import Os
from .product import Product
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class KbArticle(UncheckedBaseModel):
    """
    The KB Article object contains metadata that describes the patch or update.
    """

    avg_timespan: typing.Optional[Timespan] = pydantic.Field(default=None)
    """
    The average time to patch.
    """

    bulletin: typing.Optional[str] = pydantic.Field(default=None)
    """
    The kb article bulletin identifier.
    """

    classification: typing.Optional[str] = pydantic.Field(default=None)
    """
    The vendors classification of the kb article.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The date the kb article was released by the vendor.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date the kb article was released by the vendor.
    """

    install_state: typing.Optional[str] = pydantic.Field(default=None)
    """
    The install state of the kb article.
    """

    install_state_id: typing.Optional[KbArticleInstallStateId] = pydantic.Field(
        default=None
    )
    """
    The normalized install state ID of the kb article.
    """

    is_superseded: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The kb article has been replaced by another.
    """

    os: typing.Optional[Os] = pydantic.Field(default=None)
    """
    The operating system the kb article applies.
    """

    product: typing.Optional[Product] = pydantic.Field(default=None)
    """
    The product details the kb article applies.
    """

    severity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The severity of the kb article.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size in bytes for the kb article.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The kb article link from the source vendor.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the kb article.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the kb article.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
