# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .key_value_object import KeyValueObject
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Service(UncheckedBaseModel):
    """
    The Service object describes characteristics of a service, <code> e.g. AWS EC2. </code>
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels associated with the service.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the service.
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated to the service.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the service.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the service.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
