# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Technique(UncheckedBaseModel):
    """
    The MITRE Technique object describes the ATT&CK® or ATLAS™ Technique ID and/or name associated to an attack.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the attack technique. For example: <code>Active Scanning</code> or <code>AI Model Inference API Access</code>.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The versioned permalink of the attack technique. For example: <code>https://attack.mitre.org/versions/v14/techniques/T1595/</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the attack technique. For example: <code>T1595</code> or <code>AML.T0040</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
