# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...organization_webhook_base.types.webhook_filter import WebhookFilter
import pydantic
from ...operation_base.types.async_operation_request_id import AsyncOperationRequestId
import datetime as dt
from ...common.types.id import Id
from ...operation_base.types.operation_input import OperationInput
from ...operation_base.types.operation_status import OperationStatus
import typing
from ...operation_base.types.operation_error import OperationError
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OperationWebhookPayload(UncheckedBaseModel):
    event: WebhookFilter = pydantic.Field()
    """
    The event that triggered the webhook
    """

    nonce: str = pydantic.Field()
    """
    A unique identifier for this webhook event
    """

    id: AsyncOperationRequestId = pydantic.Field()
    """
    ID of the operation
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time object was originally created
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Last time object was updated
    """

    operation: str = pydantic.Field()
    """
    Name of the operation that will be run for this operation.
    """

    account_id: Id = pydantic.Field()
    """
    Account ID containing the integration.
    """

    integration_id: Id = pydantic.Field()
    """
    Integration ID to use for the operation.
    """

    input: OperationInput = pydantic.Field()
    """
    Input parameters for the operation that will be run for this operation.
    """

    status: OperationStatus = pydantic.Field()
    """
    Status of the operation
    """

    errors: typing.Optional[typing.List[OperationError]] = pydantic.Field(default=None)
    """
    Errors that occurred during the operation
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
