# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class PatternTypeOv(str, enum.Enum):
    """
    covers common pattern languages
    """

    STIX = "stix"
    PCRE = "pcre"
    SIGMA = "sigma"
    SNORT = "snort"
    SURICATA = "suricata"
    YARA = "yara"
    _UNKNOWN = "__PATTERNTYPEOV_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "PatternTypeOv":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        stix: typing.Callable[[], T_Result],
        pcre: typing.Callable[[], T_Result],
        sigma: typing.Callable[[], T_Result],
        snort: typing.Callable[[], T_Result],
        suricata: typing.Callable[[], T_Result],
        yara: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is PatternTypeOv.STIX:
            return stix()
        if self is PatternTypeOv.PCRE:
            return pcre()
        if self is PatternTypeOv.SIGMA:
            return sigma()
        if self is PatternTypeOv.SNORT:
            return snort()
        if self is PatternTypeOv.SURICATA:
            return suricata()
        if self is PatternTypeOv.YARA:
            return yara()
        return _unknown_member(self._value_)
