# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .attachment_id import AttachmentId
import pydantic
from .ticket_id import TicketId
import typing
import datetime as dt
from ...engine.types.object import Object
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AttachmentMetadata(UncheckedBaseModel):
    """
    Attachment in a ticketing system
    """

    id: AttachmentId = pydantic.Field()
    """
    Unique identifier for this attachment.
    """

    ticket_id: TicketId = pydantic.Field()
    """
    The ticket this attachment is associated with.
    """

    file_name: str = pydantic.Field()
    """
    The name of the file.
    """

    file_type: str = pydantic.Field()
    """
    The type of the file.
    """

    file_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size of the file in bytes.
    """

    created_date: dt.datetime = pydantic.Field()
    """
    The date the attachment was created.
    """

    creator: str = pydantic.Field()
    """
    The user who created the attachment.
    """

    unmapped: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The attributes that are not mapped to the attachment metadata schema. The names and values of those attributes are specific to the provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
