# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...common.types.id import Id
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class GroupSummary(UncheckedBaseModel):
    """
    The group summary object gives a summary of a group in an escalation policy. A group is a collection of agents that can be notified when certain conditions are met
    """

    id: Id = pydantic.Field()
    """
    Unique identifier for the group.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the group.
    """

    additional_properties: bool = pydantic.Field()
    """
    Indicates if the group has additional properties that can be retrieved.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
