# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...common.types.id import Id
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ScheduleSummary(UncheckedBaseModel):
    """
    The schedule summary object gives a summary of a schedule in an escalation policy. A schedule is a collection of agents that are notified at specific times
    """

    id: Id = pydantic.Field()
    """
    Unique identifier for the schedule.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the schedule.
    """

    additional_properties: bool = pydantic.Field()
    """
    Indicates if the schedule has additional properties that can be retrieved.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
