# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from .types.query_findings_response import QueryFindingsResponse
from ..core.unchecked_base_model import construct_type
from ..common.errors.bad_request_error import BadRequestError
from ..common.types.problem import Problem
from ..common.errors.unauthorized_error import UnauthorizedError
from ..common.errors.forbidden_error import ForbiddenError
from ..common.errors.not_found_error import NotFoundError
from ..common.errors.method_not_allowed_error import MethodNotAllowedError
from ..common.errors.conflict_error import ConflictError
from ..common.errors.unsupported_media_type_error import UnsupportedMediaTypeError
from ..common.errors.too_many_requests_error import TooManyRequestsError
from ..common.errors.internal_server_error import InternalServerError
from ..common.errors.not_implemented_error import NotImplementedError
from ..common.errors.bad_gateway_error import BadGatewayError
from ..common.errors.service_unavailable_error import ServiceUnavailableError
from ..common.errors.gateway_timeout_error import GatewayTimeoutError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from .types.security_finding import SecurityFinding
from .types.create_findings_response import CreateFindingsResponse
from ..ocsf.v_1_3_0.securityfinding.classes.types.severity_id import SeverityId
from .types.vulnerability_severity_filter_value import VulnerabilitySeverityFilterValue
from .types.vulnerability_state_filter_value import VulnerabilityStateFilterValue
from .types.provider_specific_finding_state import ProviderSpecificFindingState
from ..core.jsonable_encoder import jsonable_encoder
from .types.query_assets_response import QueryAssetsResponse
from .types.asset import Asset
from .types.create_asset_response import CreateAssetResponse
from .types.query_scans_response import QueryScansResponse
from .types.get_scan_activity_response import GetScanActivityResponse
from .types.upload_scan_response import UploadScanResponse
from .types.get_scan_status_response import GetScanStatusResponse
from ..assets.types.get_labels_response import GetLabelsResponse
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VulnerabilitiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def query_findings(
        self,
        *,
        meta: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        filter: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> QueryFindingsResponse:
        """
        Query vulnerability findings

        Parameters
        ----------
        meta : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Add metadata to the response by invoking meta functions. Documentation for meta functions is available at https://docs.synqly.com/api-reference/meta-functions. Not all meta function are available at every endpoint.

        limit : typing.Optional[int]
            Number of finding reports to return. Defaults to 50.

        cursor : typing.Optional[str]
            Start search from cursor position.

        filter : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter results by this query. For more information on filtering, refer to the Vulnerability Filtering Guide. Defaults to no filter. If used more than once, the queries are ANDed together.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        QueryFindingsResponse

        Examples
        --------
        from synqly import SynqlyEngine

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.query_findings(
            meta="string",
            limit=1,
            cursor="string",
            filter="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/findings",
            method="GET",
            params={
                "meta": meta,
                "limit": limit,
                "cursor": cursor,
                "filter": filter,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    QueryFindingsResponse,
                    construct_type(
                        type_=QueryFindingsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_findings(
        self,
        *,
        findings: typing.Sequence[SecurityFinding],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateFindingsResponse:
        """
        Create findings (bulk) in a vulnerability scanning system

        Parameters
        ----------
        findings : typing.Sequence[SecurityFinding]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateFindingsResponse

        Examples
        --------
        import datetime

        from synqly import SynqlyEngine
        from synqly.ocsf.v_1_3_0.securityfinding.classes import SecurityFinding
        from synqly.ocsf.v_1_3_0.securityfinding.objects import (
            Account,
            Analytic,
            Api,
            Attack,
            CisCsc,
            Cloud,
            Compliance,
            Container,
            Enrichment,
            Extension,
            Feature,
            File,
            Finding,
            Group,
            KillChainPhase,
            Logger,
            Malware,
            Metadata,
            Observable,
            Organization,
            Osint,
            Process,
            Product,
            RelatedEvent,
            Remediation,
            Request,
            ResourceDetails,
            Response,
            Service,
            Session,
            User,
            Vulnerability,
        )

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.create_findings(
            findings=[
                SecurityFinding(
                    activity_id=1,
                    activity_name="string",
                    analytic=Analytic(
                        category="string",
                        desc="string",
                        name="string",
                        related_analytics=[],
                        type="string",
                        type_id=1,
                        uid="string",
                        version="string",
                    ),
                    api=Api(
                        group=Group(),
                        operation="string",
                        request=Request(
                            uid="string",
                        ),
                        response=Response(),
                        service=Service(),
                        version="string",
                    ),
                    attacks=[Attack()],
                    category_name="string",
                    category_uid=1,
                    cis_csc=[
                        CisCsc(
                            control="string",
                        )
                    ],
                    class_uid=1,
                    cloud=Cloud(
                        account=Account(),
                        org=Organization(),
                        project_uid="string",
                        provider="string",
                        region="string",
                        zone="string",
                    ),
                    compliance=Compliance(
                        compliance_references=[],
                        compliance_standards=[],
                        control="string",
                        requirements=[],
                        standards=["string"],
                        status="string",
                        status_code="string",
                        status_detail="string",
                        status_id=1,
                    ),
                    confidence="string",
                    confidence_id=1,
                    confidence_score=1,
                    count=1,
                    custom_fields={"string": {"key": "value"}},
                    data_sources=["string"],
                    duration=1,
                    end_time=1,
                    end_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    enrichments=[
                        Enrichment(
                            data={"key": "value"},
                            name="string",
                            value="string",
                        )
                    ],
                    evidence={"key": "value"},
                    finding=Finding(
                        created_time=1,
                        created_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        desc="string",
                        first_seen_time=1,
                        first_seen_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        last_seen_time=1,
                        last_seen_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        modified_time=1,
                        modified_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        product_uid="string",
                        related_events=[
                            RelatedEvent(
                                uid="string",
                            )
                        ],
                        remediation=Remediation(
                            desc="string",
                            kb_article_list=[],
                            kb_articles=[],
                            references=[],
                        ),
                        src_url="string",
                        supporting_data={"key": "value"},
                        title="string",
                        types=["string"],
                        uid="string",
                    ),
                    impact="string",
                    impact_id=1,
                    impact_score=1,
                    kill_chain=[
                        KillChainPhase(
                            phase_id=1,
                        )
                    ],
                    malware=[
                        Malware(
                            classification_ids=[],
                        )
                    ],
                    message="string",
                    metadata=Metadata(
                        correlation_uid="string",
                        event_code="string",
                        extension=Extension(
                            name="string",
                            uid="string",
                            version="string",
                        ),
                        extensions=[
                            Extension(
                                name="string",
                                uid="string",
                                version="string",
                            )
                        ],
                        labels=["string"],
                        log_level="string",
                        log_name="string",
                        log_provider="string",
                        log_version="string",
                        logged_time=1,
                        logged_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        loggers=[Logger()],
                        modified_time=1,
                        modified_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        original_time="string",
                        processed_time=1,
                        processed_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        product=Product(
                            cpe_name="string",
                            distribution_mode="string",
                            feature=Feature(
                                name="string",
                                uid="string",
                                version="string",
                            ),
                            lang="string",
                            name="string",
                            path="string",
                            uid="string",
                            url_string="string",
                            vendor_name="string",
                            version="string",
                            workload="string",
                        ),
                        profiles=["string"],
                        sequence=1,
                        tenant_uid="string",
                        uid="string",
                        version="string",
                    ),
                    nist=["string"],
                    observables=[
                        Observable(
                            name="string",
                            type_id=1,
                        )
                    ],
                    osint=[
                        Osint(
                            type_id=1,
                            value="string",
                        )
                    ],
                    process=Process(
                        auid=1,
                        cmd_line="string",
                        container=Container(),
                        created_time=1,
                        created_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        egid=1,
                        euid=1,
                        file=File(
                            name="string",
                            type_id=1,
                        ),
                        group=Group(),
                        integrity="string",
                        integrity_id=1,
                        lineage=[],
                        loaded_modules=[],
                        name="string",
                        namespace_pid=1,
                        parent_process={},
                        pid=1,
                        sandbox="string",
                        session=Session(),
                        terminated_time=1,
                        terminated_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        tid=1,
                        uid="string",
                        user=User(),
                        xattributes={},
                    ),
                    raw_data="string",
                    resources=[ResourceDetails()],
                    risk_level="string",
                    risk_level_id=1,
                    risk_score=1,
                    severity="string",
                    severity_id=1,
                    start_time=1,
                    start_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    state="string",
                    state_id=1,
                    status="string",
                    status_code="string",
                    status_detail="string",
                    status_id=1,
                    time=1,
                    time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    timezone_offset=1,
                    type_name="string",
                    type_uid=1,
                    unmapped={"string": {"key": "value"}},
                    vulnerabilities=[Vulnerability()],
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/findings/bulk",
            method="POST",
            json={
                "findings": findings,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateFindingsResponse,
                    construct_type(
                        type_=CreateFindingsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_finding(
        self,
        finding_id: str,
        *,
        severity_id: SeverityId,
        severity: typing.Optional[VulnerabilitySeverityFilterValue] = OMIT,
        state: typing.Optional[VulnerabilityStateFilterValue] = OMIT,
        unmapped: typing.Optional[ProviderSpecificFindingState] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        update a finding in a vulnerability scanning system

        Parameters
        ----------
        finding_id : str
            Uid of the Finding (URL encoded). This will be `finding.uid` in the OCSF model.

        severity_id : SeverityId

        severity : typing.Optional[VulnerabilitySeverityFilterValue]
            severity of the finding

        state : typing.Optional[VulnerabilityStateFilterValue]
            state of the finding

        unmapped : typing.Optional[ProviderSpecificFindingState]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from synqly import SynqlyEngine
        from synqly.vulnerabilities import (
            ProviderSpecificFindingState_Nucleus,
            VulnerabilitySeverityFilterValue,
            VulnerabilityStateFilterValue,
        )

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.update_finding(
            finding_id="string",
            severity_id=1,
            severity=VulnerabilitySeverityFilterValue.CRITICAL,
            state=VulnerabilityStateFilterValue.UNKNOWN,
            unmapped=ProviderSpecificFindingState_Nucleus(),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/vulnerabilities/findings/{jsonable_encoder(finding_id)}",
            method="PUT",
            json={
                "severity_id": severity_id,
                "severity": severity,
                "state": state,
                "unmapped": unmapped,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def query_assets(
        self,
        *,
        meta: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        filter: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> QueryAssetsResponse:
        """
        Query assets in a vulnerability scanning system

        Parameters
        ----------
        meta : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Add metadata to the response by invoking meta functions. Documentation for meta functions is available at https://docs.synqly.com/api-reference/meta-functions. Not all meta function are available at every endpoint.

        limit : typing.Optional[int]
            Number of assets to return. Defaults to 50.

        cursor : typing.Optional[str]
            Start search from cursor position.

        filter : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter results by this query. For more information on filtering, refer to the Vulnerability Filtering Guide.
            Defaults to no filter. If used more than once, the queries are ANDed together.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        QueryAssetsResponse

        Examples
        --------
        from synqly import SynqlyEngine

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.query_assets(
            meta="string",
            limit=1,
            cursor="string",
            filter="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/assets",
            method="GET",
            params={
                "meta": meta,
                "limit": limit,
                "cursor": cursor,
                "filter": filter,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    QueryAssetsResponse,
                    construct_type(
                        type_=QueryAssetsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_asset(
        self,
        *,
        asset: Asset,
        source_name: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[CreateAssetResponse]:
        """
        Create assets in a vulnerability scanning system

        Parameters
        ----------
        asset : Asset
            Asset to create in the vulnerability scanning system.

        source_name : str
            Name of the source that created the asset.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[CreateAssetResponse]

        Examples
        --------
        import datetime

        from synqly import SynqlyEngine
        from synqly.ocsf.v_1_3_0.inventoryinfo.classes import InventoryInfo
        from synqly.ocsf.v_1_3_0.inventoryinfo.objects import (
            Account,
            Actor,
            Agent,
            Api,
            Cloud,
            Container,
            Device,
            DeviceHwInfo,
            Display,
            Enrichment,
            Extension,
            Fingerprint,
            Group,
            Idp,
            Image,
            KeyboardInfo,
            Location,
            Logger,
            Metadata,
            NetworkInterface,
            Observable,
            Organization,
            Os,
            Osint,
            Process,
            Product,
            Request,
            Response,
            Service,
            Session,
            User,
        )

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.create_asset(
            asset=InventoryInfo(
                activity_id=1,
                activity_name="string",
                actor=Actor(
                    actor_type="string",
                    actor_type_id=1,
                    app_name="string",
                    app_uid="string",
                    authorizations=[],
                    groups=[],
                    idp=Idp(),
                    invoked_by="string",
                    process=Process(),
                    session=Session(),
                    user=User(),
                ),
                api=Api(
                    group=Group(),
                    operation="string",
                    request=Request(
                        uid="string",
                    ),
                    response=Response(),
                    service=Service(),
                    version="string",
                ),
                category_name="string",
                category_uid=1,
                class_uid=1,
                cloud=Cloud(
                    account=Account(),
                    org=Organization(),
                    project_uid="string",
                    provider="string",
                    region="string",
                    zone="string",
                ),
                count=1,
                custom_fields={"string": {"key": "value"}},
                device=Device(
                    agent_list=[Agent()],
                    autoscale_uid="string",
                    boot_time=1,
                    boot_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    container=Container(
                        hash=Fingerprint(
                            algorithm_id=1,
                            value="string",
                        ),
                        image=Image(
                            uid="string",
                        ),
                        name="string",
                        network_driver="string",
                        orchestrator="string",
                        pod_uuid="string",
                        runtime="string",
                        size=1,
                        tag="string",
                        uid="string",
                    ),
                    created_time=1,
                    created_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    desc="string",
                    domain="string",
                    first_seen_time=1,
                    first_seen_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    groups=[Group()],
                    hostname="string",
                    hw_info=DeviceHwInfo(
                        bios_date="string",
                        bios_manufacturer="string",
                        bios_uid="string",
                        bios_ver="string",
                        chassis="string",
                        cpu_bits=1,
                        cpu_cores=1,
                        cpu_count=1,
                        cpu_speed=1,
                        cpu_type="string",
                        desktop_display=Display(),
                        keyboard_info=KeyboardInfo(),
                        ram_size=1,
                        serial_number="string",
                    ),
                    hypervisor="string",
                    image=Image(
                        uid="string",
                    ),
                    imei="string",
                    instance_uid="string",
                    interface_name="string",
                    interface_uid="string",
                    ip="string",
                    ip_addresses=["string"],
                    is_compliant=True,
                    is_managed=True,
                    is_personal=True,
                    is_trusted=True,
                    last_seen_time=1,
                    last_seen_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    location=Location(
                        city="string",
                        continent="string",
                        coordinates=[],
                        country="string",
                        desc="string",
                        geohash="string",
                        is_on_premises=True,
                        isp="string",
                        lat=1.1,
                        long_=1.1,
                        postal_code="string",
                        provider="string",
                        region="string",
                        timezone="string",
                    ),
                    mac="string",
                    mac_addresses=["string"],
                    modified_time=1,
                    modified_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    name="string",
                    namespace_pid=1,
                    netbios_names=["string"],
                    network_interfaces=[
                        NetworkInterface(
                            type_id=1,
                        )
                    ],
                    network_status="string",
                    network_status_id=1,
                    org=Organization(),
                    os=Os(
                        build="string",
                        country="string",
                        cpe_name="string",
                        cpu_bits=1,
                        edition="string",
                        lang="string",
                        name="string",
                        sp_name="string",
                        sp_ver=1,
                        type="string",
                        type_id=1,
                        version="string",
                    ),
                    owner=User(),
                    region="string",
                    risk_level="string",
                    risk_level_id=1,
                    risk_score=1,
                    subnet="string",
                    subnet_uid="string",
                    sw_info=[Product()],
                    type="string",
                    type_id=1,
                    uid="string",
                    uid_alt="string",
                    vendor=Organization(),
                    vlan_uid="string",
                    vpc_uid="string",
                    zone="string",
                ),
                duration=1,
                end_time=1,
                end_time_dt=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                enrichments=[
                    Enrichment(
                        data={"key": "value"},
                        name="string",
                        value="string",
                    )
                ],
                message="string",
                metadata=Metadata(
                    correlation_uid="string",
                    event_code="string",
                    extension=Extension(
                        name="string",
                        uid="string",
                        version="string",
                    ),
                    extensions=[
                        Extension(
                            name="string",
                            uid="string",
                            version="string",
                        )
                    ],
                    labels=["string"],
                    log_level="string",
                    log_name="string",
                    log_provider="string",
                    log_version="string",
                    logged_time=1,
                    logged_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    loggers=[Logger()],
                    modified_time=1,
                    modified_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    original_time="string",
                    processed_time=1,
                    processed_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    product=Product(),
                    profiles=["string"],
                    sequence=1,
                    tenant_uid="string",
                    uid="string",
                    version="string",
                ),
                observables=[
                    Observable(
                        name="string",
                        type_id=1,
                    )
                ],
                osint=[
                    Osint(
                        type_id=1,
                        value="string",
                    )
                ],
                raw_data="string",
                severity="string",
                severity_id=1,
                start_time=1,
                start_time_dt=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                status="string",
                status_code="string",
                status_detail="string",
                status_id=1,
                time=1,
                time_dt=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                timezone_offset=1,
                type_name="string",
                type_uid=1,
                unmapped={"string": {"key": "value"}},
            ),
            source_name="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/assets",
            method="POST",
            json={
                "asset": asset,
                "source_name": source_name,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[CreateAssetResponse],
                    construct_type(
                        type_=typing.Optional[CreateAssetResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_asset(
        self,
        asset_id: str,
        *,
        asset: Asset,
        source_name: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Asset:
        """
        update an asset in a vulnerability scanning system

        Parameters
        ----------
        asset_id : str
            Uid of the Asset. This will be `devices.uid` in the OCSF model.

        asset : Asset
            Asset to create in the vulnerability scanning system.

        source_name : str
            Name of the source that created the asset.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Asset

        Examples
        --------
        import datetime

        from synqly import SynqlyEngine
        from synqly.ocsf.v_1_3_0.inventoryinfo.classes import InventoryInfo
        from synqly.ocsf.v_1_3_0.inventoryinfo.objects import (
            Account,
            Actor,
            Agent,
            Api,
            Cloud,
            Container,
            Device,
            DeviceHwInfo,
            Display,
            Enrichment,
            Extension,
            Fingerprint,
            Group,
            Idp,
            Image,
            KeyboardInfo,
            Location,
            Logger,
            Metadata,
            NetworkInterface,
            Observable,
            Organization,
            Os,
            Osint,
            Process,
            Product,
            Request,
            Response,
            Service,
            Session,
            User,
        )

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.update_asset(
            asset_id="string",
            asset=InventoryInfo(
                activity_id=1,
                activity_name="string",
                actor=Actor(
                    actor_type="string",
                    actor_type_id=1,
                    app_name="string",
                    app_uid="string",
                    authorizations=[],
                    groups=[],
                    idp=Idp(),
                    invoked_by="string",
                    process=Process(),
                    session=Session(),
                    user=User(),
                ),
                api=Api(
                    group=Group(),
                    operation="string",
                    request=Request(
                        uid="string",
                    ),
                    response=Response(),
                    service=Service(),
                    version="string",
                ),
                category_name="string",
                category_uid=1,
                class_uid=1,
                cloud=Cloud(
                    account=Account(),
                    org=Organization(),
                    project_uid="string",
                    provider="string",
                    region="string",
                    zone="string",
                ),
                count=1,
                custom_fields={"string": {"key": "value"}},
                device=Device(
                    agent_list=[Agent()],
                    autoscale_uid="string",
                    boot_time=1,
                    boot_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    container=Container(
                        hash=Fingerprint(
                            algorithm_id=1,
                            value="string",
                        ),
                        image=Image(
                            uid="string",
                        ),
                        name="string",
                        network_driver="string",
                        orchestrator="string",
                        pod_uuid="string",
                        runtime="string",
                        size=1,
                        tag="string",
                        uid="string",
                    ),
                    created_time=1,
                    created_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    desc="string",
                    domain="string",
                    first_seen_time=1,
                    first_seen_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    groups=[Group()],
                    hostname="string",
                    hw_info=DeviceHwInfo(
                        bios_date="string",
                        bios_manufacturer="string",
                        bios_uid="string",
                        bios_ver="string",
                        chassis="string",
                        cpu_bits=1,
                        cpu_cores=1,
                        cpu_count=1,
                        cpu_speed=1,
                        cpu_type="string",
                        desktop_display=Display(),
                        keyboard_info=KeyboardInfo(),
                        ram_size=1,
                        serial_number="string",
                    ),
                    hypervisor="string",
                    image=Image(
                        uid="string",
                    ),
                    imei="string",
                    instance_uid="string",
                    interface_name="string",
                    interface_uid="string",
                    ip="string",
                    ip_addresses=["string"],
                    is_compliant=True,
                    is_managed=True,
                    is_personal=True,
                    is_trusted=True,
                    last_seen_time=1,
                    last_seen_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    location=Location(
                        city="string",
                        continent="string",
                        coordinates=[],
                        country="string",
                        desc="string",
                        geohash="string",
                        is_on_premises=True,
                        isp="string",
                        lat=1.1,
                        long_=1.1,
                        postal_code="string",
                        provider="string",
                        region="string",
                        timezone="string",
                    ),
                    mac="string",
                    mac_addresses=["string"],
                    modified_time=1,
                    modified_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    name="string",
                    namespace_pid=1,
                    netbios_names=["string"],
                    network_interfaces=[
                        NetworkInterface(
                            type_id=1,
                        )
                    ],
                    network_status="string",
                    network_status_id=1,
                    org=Organization(),
                    os=Os(
                        build="string",
                        country="string",
                        cpe_name="string",
                        cpu_bits=1,
                        edition="string",
                        lang="string",
                        name="string",
                        sp_name="string",
                        sp_ver=1,
                        type="string",
                        type_id=1,
                        version="string",
                    ),
                    owner=User(),
                    region="string",
                    risk_level="string",
                    risk_level_id=1,
                    risk_score=1,
                    subnet="string",
                    subnet_uid="string",
                    sw_info=[Product()],
                    type="string",
                    type_id=1,
                    uid="string",
                    uid_alt="string",
                    vendor=Organization(),
                    vlan_uid="string",
                    vpc_uid="string",
                    zone="string",
                ),
                duration=1,
                end_time=1,
                end_time_dt=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                enrichments=[
                    Enrichment(
                        data={"key": "value"},
                        name="string",
                        value="string",
                    )
                ],
                message="string",
                metadata=Metadata(
                    correlation_uid="string",
                    event_code="string",
                    extension=Extension(
                        name="string",
                        uid="string",
                        version="string",
                    ),
                    extensions=[
                        Extension(
                            name="string",
                            uid="string",
                            version="string",
                        )
                    ],
                    labels=["string"],
                    log_level="string",
                    log_name="string",
                    log_provider="string",
                    log_version="string",
                    logged_time=1,
                    logged_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    loggers=[Logger()],
                    modified_time=1,
                    modified_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    original_time="string",
                    processed_time=1,
                    processed_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    product=Product(),
                    profiles=["string"],
                    sequence=1,
                    tenant_uid="string",
                    uid="string",
                    version="string",
                ),
                observables=[
                    Observable(
                        name="string",
                        type_id=1,
                    )
                ],
                osint=[
                    Osint(
                        type_id=1,
                        value="string",
                    )
                ],
                raw_data="string",
                severity="string",
                severity_id=1,
                start_time=1,
                start_time_dt=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                status="string",
                status_code="string",
                status_detail="string",
                status_id=1,
                time=1,
                time_dt=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                timezone_offset=1,
                type_name="string",
                type_uid=1,
                unmapped={"string": {"key": "value"}},
            ),
            source_name="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/vulnerabilities/assets/{jsonable_encoder(asset_id)}",
            method="PUT",
            json={
                "asset": asset,
                "source_name": source_name,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Asset,
                    construct_type(
                        type_=Asset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def query_scans(
        self,
        *,
        meta: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> QueryScansResponse:
        """
        Query scans in a vulnerability scanning system

        Parameters
        ----------
        meta : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Add metadata to the response by invoking meta functions. Documentation for meta functions is available at https://docs.synqly.com/api-reference/meta-functions. Not all meta function are available at every endpoint.

        limit : typing.Optional[int]
            Number of scans to return. Defaults to 50.

        cursor : typing.Optional[str]
            Start search from cursor position.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        QueryScansResponse

        Examples
        --------
        from synqly import SynqlyEngine

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.query_scans(
            meta="string",
            limit=1,
            cursor="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/scans",
            method="GET",
            params={
                "meta": meta,
                "limit": limit,
                "cursor": cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    QueryScansResponse,
                    construct_type(
                        type_=QueryScansResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_scan_activity(
        self, scan_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetScanActivityResponse:
        """
        Get a list of activity generated by a configured scan.

        Parameters
        ----------
        scan_id : str
            ID of the scan to get its activity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetScanActivityResponse

        Examples
        --------
        from synqly import SynqlyEngine

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.get_scan_activity(
            scan_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/vulnerabilities/scans/{jsonable_encoder(scan_id)}/activity",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetScanActivityResponse,
                    construct_type(
                        type_=GetScanActivityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def upload_scan(
        self,
        *,
        assets: typing.Sequence[Asset],
        source_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UploadScanResponse:
        """
        Upload a scan in a vulnerability scanning system

        Parameters
        ----------
        assets : typing.Sequence[Asset]
            Assets and optional findings to upload in the vulnerability scanning system.

        source_name : typing.Optional[str]
            Name of the source for this scan, such as a tool or process. Does not have to be unique, defaults to `Integration import`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadScanResponse

        Examples
        --------
        import datetime

        from synqly import SynqlyEngine
        from synqly.ocsf.v_1_3_0.inventoryinfo.classes import InventoryInfo
        from synqly.ocsf.v_1_3_0.inventoryinfo.objects import (
            Account,
            Actor,
            Agent,
            Api,
            Cloud,
            Container,
            Device,
            DeviceHwInfo,
            Display,
            Enrichment,
            Extension,
            Fingerprint,
            Group,
            Idp,
            Image,
            KeyboardInfo,
            Location,
            Logger,
            Metadata,
            NetworkInterface,
            Observable,
            Organization,
            Os,
            Osint,
            Process,
            Product,
            Request,
            Response,
            Service,
            Session,
            User,
        )

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.upload_scan(
            assets=[
                InventoryInfo(
                    activity_id=1,
                    activity_name="string",
                    actor=Actor(
                        actor_type="string",
                        actor_type_id=1,
                        app_name="string",
                        app_uid="string",
                        authorizations=[],
                        groups=[],
                        idp=Idp(),
                        invoked_by="string",
                        process=Process(),
                        session=Session(),
                        user=User(),
                    ),
                    api=Api(
                        group=Group(),
                        operation="string",
                        request=Request(
                            uid="string",
                        ),
                        response=Response(),
                        service=Service(),
                        version="string",
                    ),
                    category_name="string",
                    category_uid=1,
                    class_uid=1,
                    cloud=Cloud(
                        account=Account(),
                        org=Organization(),
                        project_uid="string",
                        provider="string",
                        region="string",
                        zone="string",
                    ),
                    count=1,
                    custom_fields={"string": {"key": "value"}},
                    device=Device(
                        agent_list=[Agent()],
                        autoscale_uid="string",
                        boot_time=1,
                        boot_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        container=Container(
                            hash=Fingerprint(
                                algorithm_id=1,
                                value="string",
                            ),
                            image=Image(
                                uid="string",
                            ),
                            name="string",
                            network_driver="string",
                            orchestrator="string",
                            pod_uuid="string",
                            runtime="string",
                            size=1,
                            tag="string",
                            uid="string",
                        ),
                        created_time=1,
                        created_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        desc="string",
                        domain="string",
                        first_seen_time=1,
                        first_seen_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        groups=[Group()],
                        hostname="string",
                        hw_info=DeviceHwInfo(
                            bios_date="string",
                            bios_manufacturer="string",
                            bios_uid="string",
                            bios_ver="string",
                            chassis="string",
                            cpu_bits=1,
                            cpu_cores=1,
                            cpu_count=1,
                            cpu_speed=1,
                            cpu_type="string",
                            desktop_display=Display(),
                            keyboard_info=KeyboardInfo(),
                            ram_size=1,
                            serial_number="string",
                        ),
                        hypervisor="string",
                        image=Image(
                            uid="string",
                        ),
                        imei="string",
                        instance_uid="string",
                        interface_name="string",
                        interface_uid="string",
                        ip="string",
                        ip_addresses=["string"],
                        is_compliant=True,
                        is_managed=True,
                        is_personal=True,
                        is_trusted=True,
                        last_seen_time=1,
                        last_seen_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        location=Location(
                            city="string",
                            continent="string",
                            coordinates=[],
                            country="string",
                            desc="string",
                            geohash="string",
                            is_on_premises=True,
                            isp="string",
                            lat=1.1,
                            long_=1.1,
                            postal_code="string",
                            provider="string",
                            region="string",
                            timezone="string",
                        ),
                        mac="string",
                        mac_addresses=["string"],
                        modified_time=1,
                        modified_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        name="string",
                        namespace_pid=1,
                        netbios_names=["string"],
                        network_interfaces=[
                            NetworkInterface(
                                type_id=1,
                            )
                        ],
                        network_status="string",
                        network_status_id=1,
                        org=Organization(),
                        os=Os(
                            build="string",
                            country="string",
                            cpe_name="string",
                            cpu_bits=1,
                            edition="string",
                            lang="string",
                            name="string",
                            sp_name="string",
                            sp_ver=1,
                            type="string",
                            type_id=1,
                            version="string",
                        ),
                        owner=User(),
                        region="string",
                        risk_level="string",
                        risk_level_id=1,
                        risk_score=1,
                        subnet="string",
                        subnet_uid="string",
                        sw_info=[Product()],
                        type="string",
                        type_id=1,
                        uid="string",
                        uid_alt="string",
                        vendor=Organization(),
                        vlan_uid="string",
                        vpc_uid="string",
                        zone="string",
                    ),
                    duration=1,
                    end_time=1,
                    end_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    enrichments=[
                        Enrichment(
                            data={"key": "value"},
                            name="string",
                            value="string",
                        )
                    ],
                    message="string",
                    metadata=Metadata(
                        correlation_uid="string",
                        event_code="string",
                        extension=Extension(
                            name="string",
                            uid="string",
                            version="string",
                        ),
                        extensions=[
                            Extension(
                                name="string",
                                uid="string",
                                version="string",
                            )
                        ],
                        labels=["string"],
                        log_level="string",
                        log_name="string",
                        log_provider="string",
                        log_version="string",
                        logged_time=1,
                        logged_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        loggers=[Logger()],
                        modified_time=1,
                        modified_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        original_time="string",
                        processed_time=1,
                        processed_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        product=Product(),
                        profiles=["string"],
                        sequence=1,
                        tenant_uid="string",
                        uid="string",
                        version="string",
                    ),
                    observables=[
                        Observable(
                            name="string",
                            type_id=1,
                        )
                    ],
                    osint=[
                        Osint(
                            type_id=1,
                            value="string",
                        )
                    ],
                    raw_data="string",
                    severity="string",
                    severity_id=1,
                    start_time=1,
                    start_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    status="string",
                    status_code="string",
                    status_detail="string",
                    status_id=1,
                    time=1,
                    time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    timezone_offset=1,
                    type_name="string",
                    type_uid=1,
                    unmapped={"string": {"key": "value"}},
                )
            ],
            source_name="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/scans",
            method="POST",
            json={
                "assets": assets,
                "source_name": source_name,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UploadScanResponse,
                    construct_type(
                        type_=UploadScanResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_scan_status(
        self, scan_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetScanStatusResponse:
        """
        Get the status of a upload scan

        Parameters
        ----------
        scan_id : str
            ID of the scan to get the status of.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetScanStatusResponse

        Examples
        --------
        from synqly import SynqlyEngine

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.get_scan_status(
            scan_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/vulnerabilities/scans/{jsonable_encoder(scan_id)}/status",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetScanStatusResponse,
                    construct_type(
                        type_=GetScanStatusResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_labels(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetLabelsResponse:
        """
        Get labels from an asset inventory system

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetLabelsResponse

        Examples
        --------
        from synqly import SynqlyEngine

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.vulnerabilities.get_labels()
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/labels",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetLabelsResponse,
                    construct_type(
                        type_=GetLabelsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncVulnerabilitiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def query_findings(
        self,
        *,
        meta: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        filter: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> QueryFindingsResponse:
        """
        Query vulnerability findings

        Parameters
        ----------
        meta : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Add metadata to the response by invoking meta functions. Documentation for meta functions is available at https://docs.synqly.com/api-reference/meta-functions. Not all meta function are available at every endpoint.

        limit : typing.Optional[int]
            Number of finding reports to return. Defaults to 50.

        cursor : typing.Optional[str]
            Start search from cursor position.

        filter : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter results by this query. For more information on filtering, refer to the Vulnerability Filtering Guide. Defaults to no filter. If used more than once, the queries are ANDed together.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        QueryFindingsResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyEngine

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.query_findings(
                meta="string",
                limit=1,
                cursor="string",
                filter="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/findings",
            method="GET",
            params={
                "meta": meta,
                "limit": limit,
                "cursor": cursor,
                "filter": filter,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    QueryFindingsResponse,
                    construct_type(
                        type_=QueryFindingsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_findings(
        self,
        *,
        findings: typing.Sequence[SecurityFinding],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateFindingsResponse:
        """
        Create findings (bulk) in a vulnerability scanning system

        Parameters
        ----------
        findings : typing.Sequence[SecurityFinding]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateFindingsResponse

        Examples
        --------
        import asyncio
        import datetime

        from synqly import AsyncSynqlyEngine
        from synqly.ocsf.v_1_3_0.securityfinding.classes import SecurityFinding
        from synqly.ocsf.v_1_3_0.securityfinding.objects import (
            Account,
            Analytic,
            Api,
            Attack,
            CisCsc,
            Cloud,
            Compliance,
            Container,
            Enrichment,
            Extension,
            Feature,
            File,
            Finding,
            Group,
            KillChainPhase,
            Logger,
            Malware,
            Metadata,
            Observable,
            Organization,
            Osint,
            Process,
            Product,
            RelatedEvent,
            Remediation,
            Request,
            ResourceDetails,
            Response,
            Service,
            Session,
            User,
            Vulnerability,
        )

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.create_findings(
                findings=[
                    SecurityFinding(
                        activity_id=1,
                        activity_name="string",
                        analytic=Analytic(
                            category="string",
                            desc="string",
                            name="string",
                            related_analytics=[],
                            type="string",
                            type_id=1,
                            uid="string",
                            version="string",
                        ),
                        api=Api(
                            group=Group(),
                            operation="string",
                            request=Request(
                                uid="string",
                            ),
                            response=Response(),
                            service=Service(),
                            version="string",
                        ),
                        attacks=[Attack()],
                        category_name="string",
                        category_uid=1,
                        cis_csc=[
                            CisCsc(
                                control="string",
                            )
                        ],
                        class_uid=1,
                        cloud=Cloud(
                            account=Account(),
                            org=Organization(),
                            project_uid="string",
                            provider="string",
                            region="string",
                            zone="string",
                        ),
                        compliance=Compliance(
                            compliance_references=[],
                            compliance_standards=[],
                            control="string",
                            requirements=[],
                            standards=["string"],
                            status="string",
                            status_code="string",
                            status_detail="string",
                            status_id=1,
                        ),
                        confidence="string",
                        confidence_id=1,
                        confidence_score=1,
                        count=1,
                        custom_fields={"string": {"key": "value"}},
                        data_sources=["string"],
                        duration=1,
                        end_time=1,
                        end_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        enrichments=[
                            Enrichment(
                                data={"key": "value"},
                                name="string",
                                value="string",
                            )
                        ],
                        evidence={"key": "value"},
                        finding=Finding(
                            created_time=1,
                            created_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            desc="string",
                            first_seen_time=1,
                            first_seen_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            last_seen_time=1,
                            last_seen_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            modified_time=1,
                            modified_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            product_uid="string",
                            related_events=[
                                RelatedEvent(
                                    uid="string",
                                )
                            ],
                            remediation=Remediation(
                                desc="string",
                                kb_article_list=[],
                                kb_articles=[],
                                references=[],
                            ),
                            src_url="string",
                            supporting_data={"key": "value"},
                            title="string",
                            types=["string"],
                            uid="string",
                        ),
                        impact="string",
                        impact_id=1,
                        impact_score=1,
                        kill_chain=[
                            KillChainPhase(
                                phase_id=1,
                            )
                        ],
                        malware=[
                            Malware(
                                classification_ids=[],
                            )
                        ],
                        message="string",
                        metadata=Metadata(
                            correlation_uid="string",
                            event_code="string",
                            extension=Extension(
                                name="string",
                                uid="string",
                                version="string",
                            ),
                            extensions=[
                                Extension(
                                    name="string",
                                    uid="string",
                                    version="string",
                                )
                            ],
                            labels=["string"],
                            log_level="string",
                            log_name="string",
                            log_provider="string",
                            log_version="string",
                            logged_time=1,
                            logged_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            loggers=[Logger()],
                            modified_time=1,
                            modified_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            original_time="string",
                            processed_time=1,
                            processed_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            product=Product(
                                cpe_name="string",
                                distribution_mode="string",
                                feature=Feature(
                                    name="string",
                                    uid="string",
                                    version="string",
                                ),
                                lang="string",
                                name="string",
                                path="string",
                                uid="string",
                                url_string="string",
                                vendor_name="string",
                                version="string",
                                workload="string",
                            ),
                            profiles=["string"],
                            sequence=1,
                            tenant_uid="string",
                            uid="string",
                            version="string",
                        ),
                        nist=["string"],
                        observables=[
                            Observable(
                                name="string",
                                type_id=1,
                            )
                        ],
                        osint=[
                            Osint(
                                type_id=1,
                                value="string",
                            )
                        ],
                        process=Process(
                            auid=1,
                            cmd_line="string",
                            container=Container(),
                            created_time=1,
                            created_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            egid=1,
                            euid=1,
                            file=File(
                                name="string",
                                type_id=1,
                            ),
                            group=Group(),
                            integrity="string",
                            integrity_id=1,
                            lineage=[],
                            loaded_modules=[],
                            name="string",
                            namespace_pid=1,
                            parent_process={},
                            pid=1,
                            sandbox="string",
                            session=Session(),
                            terminated_time=1,
                            terminated_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            tid=1,
                            uid="string",
                            user=User(),
                            xattributes={},
                        ),
                        raw_data="string",
                        resources=[ResourceDetails()],
                        risk_level="string",
                        risk_level_id=1,
                        risk_score=1,
                        severity="string",
                        severity_id=1,
                        start_time=1,
                        start_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        state="string",
                        state_id=1,
                        status="string",
                        status_code="string",
                        status_detail="string",
                        status_id=1,
                        time=1,
                        time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        timezone_offset=1,
                        type_name="string",
                        type_uid=1,
                        unmapped={"string": {"key": "value"}},
                        vulnerabilities=[Vulnerability()],
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/findings/bulk",
            method="POST",
            json={
                "findings": findings,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateFindingsResponse,
                    construct_type(
                        type_=CreateFindingsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_finding(
        self,
        finding_id: str,
        *,
        severity_id: SeverityId,
        severity: typing.Optional[VulnerabilitySeverityFilterValue] = OMIT,
        state: typing.Optional[VulnerabilityStateFilterValue] = OMIT,
        unmapped: typing.Optional[ProviderSpecificFindingState] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        update a finding in a vulnerability scanning system

        Parameters
        ----------
        finding_id : str
            Uid of the Finding (URL encoded). This will be `finding.uid` in the OCSF model.

        severity_id : SeverityId

        severity : typing.Optional[VulnerabilitySeverityFilterValue]
            severity of the finding

        state : typing.Optional[VulnerabilityStateFilterValue]
            state of the finding

        unmapped : typing.Optional[ProviderSpecificFindingState]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyEngine
        from synqly.vulnerabilities import (
            ProviderSpecificFindingState_Nucleus,
            VulnerabilitySeverityFilterValue,
            VulnerabilityStateFilterValue,
        )

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.update_finding(
                finding_id="string",
                severity_id=1,
                severity=VulnerabilitySeverityFilterValue.CRITICAL,
                state=VulnerabilityStateFilterValue.UNKNOWN,
                unmapped=ProviderSpecificFindingState_Nucleus(),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/vulnerabilities/findings/{jsonable_encoder(finding_id)}",
            method="PUT",
            json={
                "severity_id": severity_id,
                "severity": severity,
                "state": state,
                "unmapped": unmapped,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def query_assets(
        self,
        *,
        meta: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        filter: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> QueryAssetsResponse:
        """
        Query assets in a vulnerability scanning system

        Parameters
        ----------
        meta : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Add metadata to the response by invoking meta functions. Documentation for meta functions is available at https://docs.synqly.com/api-reference/meta-functions. Not all meta function are available at every endpoint.

        limit : typing.Optional[int]
            Number of assets to return. Defaults to 50.

        cursor : typing.Optional[str]
            Start search from cursor position.

        filter : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter results by this query. For more information on filtering, refer to the Vulnerability Filtering Guide.
            Defaults to no filter. If used more than once, the queries are ANDed together.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        QueryAssetsResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyEngine

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.query_assets(
                meta="string",
                limit=1,
                cursor="string",
                filter="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/assets",
            method="GET",
            params={
                "meta": meta,
                "limit": limit,
                "cursor": cursor,
                "filter": filter,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    QueryAssetsResponse,
                    construct_type(
                        type_=QueryAssetsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_asset(
        self,
        *,
        asset: Asset,
        source_name: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[CreateAssetResponse]:
        """
        Create assets in a vulnerability scanning system

        Parameters
        ----------
        asset : Asset
            Asset to create in the vulnerability scanning system.

        source_name : str
            Name of the source that created the asset.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[CreateAssetResponse]

        Examples
        --------
        import asyncio
        import datetime

        from synqly import AsyncSynqlyEngine
        from synqly.ocsf.v_1_3_0.inventoryinfo.classes import InventoryInfo
        from synqly.ocsf.v_1_3_0.inventoryinfo.objects import (
            Account,
            Actor,
            Agent,
            Api,
            Cloud,
            Container,
            Device,
            DeviceHwInfo,
            Display,
            Enrichment,
            Extension,
            Fingerprint,
            Group,
            Idp,
            Image,
            KeyboardInfo,
            Location,
            Logger,
            Metadata,
            NetworkInterface,
            Observable,
            Organization,
            Os,
            Osint,
            Process,
            Product,
            Request,
            Response,
            Service,
            Session,
            User,
        )

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.create_asset(
                asset=InventoryInfo(
                    activity_id=1,
                    activity_name="string",
                    actor=Actor(
                        actor_type="string",
                        actor_type_id=1,
                        app_name="string",
                        app_uid="string",
                        authorizations=[],
                        groups=[],
                        idp=Idp(),
                        invoked_by="string",
                        process=Process(),
                        session=Session(),
                        user=User(),
                    ),
                    api=Api(
                        group=Group(),
                        operation="string",
                        request=Request(
                            uid="string",
                        ),
                        response=Response(),
                        service=Service(),
                        version="string",
                    ),
                    category_name="string",
                    category_uid=1,
                    class_uid=1,
                    cloud=Cloud(
                        account=Account(),
                        org=Organization(),
                        project_uid="string",
                        provider="string",
                        region="string",
                        zone="string",
                    ),
                    count=1,
                    custom_fields={"string": {"key": "value"}},
                    device=Device(
                        agent_list=[Agent()],
                        autoscale_uid="string",
                        boot_time=1,
                        boot_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        container=Container(
                            hash=Fingerprint(
                                algorithm_id=1,
                                value="string",
                            ),
                            image=Image(
                                uid="string",
                            ),
                            name="string",
                            network_driver="string",
                            orchestrator="string",
                            pod_uuid="string",
                            runtime="string",
                            size=1,
                            tag="string",
                            uid="string",
                        ),
                        created_time=1,
                        created_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        desc="string",
                        domain="string",
                        first_seen_time=1,
                        first_seen_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        groups=[Group()],
                        hostname="string",
                        hw_info=DeviceHwInfo(
                            bios_date="string",
                            bios_manufacturer="string",
                            bios_uid="string",
                            bios_ver="string",
                            chassis="string",
                            cpu_bits=1,
                            cpu_cores=1,
                            cpu_count=1,
                            cpu_speed=1,
                            cpu_type="string",
                            desktop_display=Display(),
                            keyboard_info=KeyboardInfo(),
                            ram_size=1,
                            serial_number="string",
                        ),
                        hypervisor="string",
                        image=Image(
                            uid="string",
                        ),
                        imei="string",
                        instance_uid="string",
                        interface_name="string",
                        interface_uid="string",
                        ip="string",
                        ip_addresses=["string"],
                        is_compliant=True,
                        is_managed=True,
                        is_personal=True,
                        is_trusted=True,
                        last_seen_time=1,
                        last_seen_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        location=Location(
                            city="string",
                            continent="string",
                            coordinates=[],
                            country="string",
                            desc="string",
                            geohash="string",
                            is_on_premises=True,
                            isp="string",
                            lat=1.1,
                            long_=1.1,
                            postal_code="string",
                            provider="string",
                            region="string",
                            timezone="string",
                        ),
                        mac="string",
                        mac_addresses=["string"],
                        modified_time=1,
                        modified_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        name="string",
                        namespace_pid=1,
                        netbios_names=["string"],
                        network_interfaces=[
                            NetworkInterface(
                                type_id=1,
                            )
                        ],
                        network_status="string",
                        network_status_id=1,
                        org=Organization(),
                        os=Os(
                            build="string",
                            country="string",
                            cpe_name="string",
                            cpu_bits=1,
                            edition="string",
                            lang="string",
                            name="string",
                            sp_name="string",
                            sp_ver=1,
                            type="string",
                            type_id=1,
                            version="string",
                        ),
                        owner=User(),
                        region="string",
                        risk_level="string",
                        risk_level_id=1,
                        risk_score=1,
                        subnet="string",
                        subnet_uid="string",
                        sw_info=[Product()],
                        type="string",
                        type_id=1,
                        uid="string",
                        uid_alt="string",
                        vendor=Organization(),
                        vlan_uid="string",
                        vpc_uid="string",
                        zone="string",
                    ),
                    duration=1,
                    end_time=1,
                    end_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    enrichments=[
                        Enrichment(
                            data={"key": "value"},
                            name="string",
                            value="string",
                        )
                    ],
                    message="string",
                    metadata=Metadata(
                        correlation_uid="string",
                        event_code="string",
                        extension=Extension(
                            name="string",
                            uid="string",
                            version="string",
                        ),
                        extensions=[
                            Extension(
                                name="string",
                                uid="string",
                                version="string",
                            )
                        ],
                        labels=["string"],
                        log_level="string",
                        log_name="string",
                        log_provider="string",
                        log_version="string",
                        logged_time=1,
                        logged_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        loggers=[Logger()],
                        modified_time=1,
                        modified_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        original_time="string",
                        processed_time=1,
                        processed_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        product=Product(),
                        profiles=["string"],
                        sequence=1,
                        tenant_uid="string",
                        uid="string",
                        version="string",
                    ),
                    observables=[
                        Observable(
                            name="string",
                            type_id=1,
                        )
                    ],
                    osint=[
                        Osint(
                            type_id=1,
                            value="string",
                        )
                    ],
                    raw_data="string",
                    severity="string",
                    severity_id=1,
                    start_time=1,
                    start_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    status="string",
                    status_code="string",
                    status_detail="string",
                    status_id=1,
                    time=1,
                    time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    timezone_offset=1,
                    type_name="string",
                    type_uid=1,
                    unmapped={"string": {"key": "value"}},
                ),
                source_name="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/assets",
            method="POST",
            json={
                "asset": asset,
                "source_name": source_name,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    typing.Optional[CreateAssetResponse],
                    construct_type(
                        type_=typing.Optional[CreateAssetResponse],  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_asset(
        self,
        asset_id: str,
        *,
        asset: Asset,
        source_name: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Asset:
        """
        update an asset in a vulnerability scanning system

        Parameters
        ----------
        asset_id : str
            Uid of the Asset. This will be `devices.uid` in the OCSF model.

        asset : Asset
            Asset to create in the vulnerability scanning system.

        source_name : str
            Name of the source that created the asset.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Asset

        Examples
        --------
        import asyncio
        import datetime

        from synqly import AsyncSynqlyEngine
        from synqly.ocsf.v_1_3_0.inventoryinfo.classes import InventoryInfo
        from synqly.ocsf.v_1_3_0.inventoryinfo.objects import (
            Account,
            Actor,
            Agent,
            Api,
            Cloud,
            Container,
            Device,
            DeviceHwInfo,
            Display,
            Enrichment,
            Extension,
            Fingerprint,
            Group,
            Idp,
            Image,
            KeyboardInfo,
            Location,
            Logger,
            Metadata,
            NetworkInterface,
            Observable,
            Organization,
            Os,
            Osint,
            Process,
            Product,
            Request,
            Response,
            Service,
            Session,
            User,
        )

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.update_asset(
                asset_id="string",
                asset=InventoryInfo(
                    activity_id=1,
                    activity_name="string",
                    actor=Actor(
                        actor_type="string",
                        actor_type_id=1,
                        app_name="string",
                        app_uid="string",
                        authorizations=[],
                        groups=[],
                        idp=Idp(),
                        invoked_by="string",
                        process=Process(),
                        session=Session(),
                        user=User(),
                    ),
                    api=Api(
                        group=Group(),
                        operation="string",
                        request=Request(
                            uid="string",
                        ),
                        response=Response(),
                        service=Service(),
                        version="string",
                    ),
                    category_name="string",
                    category_uid=1,
                    class_uid=1,
                    cloud=Cloud(
                        account=Account(),
                        org=Organization(),
                        project_uid="string",
                        provider="string",
                        region="string",
                        zone="string",
                    ),
                    count=1,
                    custom_fields={"string": {"key": "value"}},
                    device=Device(
                        agent_list=[Agent()],
                        autoscale_uid="string",
                        boot_time=1,
                        boot_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        container=Container(
                            hash=Fingerprint(
                                algorithm_id=1,
                                value="string",
                            ),
                            image=Image(
                                uid="string",
                            ),
                            name="string",
                            network_driver="string",
                            orchestrator="string",
                            pod_uuid="string",
                            runtime="string",
                            size=1,
                            tag="string",
                            uid="string",
                        ),
                        created_time=1,
                        created_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        desc="string",
                        domain="string",
                        first_seen_time=1,
                        first_seen_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        groups=[Group()],
                        hostname="string",
                        hw_info=DeviceHwInfo(
                            bios_date="string",
                            bios_manufacturer="string",
                            bios_uid="string",
                            bios_ver="string",
                            chassis="string",
                            cpu_bits=1,
                            cpu_cores=1,
                            cpu_count=1,
                            cpu_speed=1,
                            cpu_type="string",
                            desktop_display=Display(),
                            keyboard_info=KeyboardInfo(),
                            ram_size=1,
                            serial_number="string",
                        ),
                        hypervisor="string",
                        image=Image(
                            uid="string",
                        ),
                        imei="string",
                        instance_uid="string",
                        interface_name="string",
                        interface_uid="string",
                        ip="string",
                        ip_addresses=["string"],
                        is_compliant=True,
                        is_managed=True,
                        is_personal=True,
                        is_trusted=True,
                        last_seen_time=1,
                        last_seen_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        location=Location(
                            city="string",
                            continent="string",
                            coordinates=[],
                            country="string",
                            desc="string",
                            geohash="string",
                            is_on_premises=True,
                            isp="string",
                            lat=1.1,
                            long_=1.1,
                            postal_code="string",
                            provider="string",
                            region="string",
                            timezone="string",
                        ),
                        mac="string",
                        mac_addresses=["string"],
                        modified_time=1,
                        modified_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        name="string",
                        namespace_pid=1,
                        netbios_names=["string"],
                        network_interfaces=[
                            NetworkInterface(
                                type_id=1,
                            )
                        ],
                        network_status="string",
                        network_status_id=1,
                        org=Organization(),
                        os=Os(
                            build="string",
                            country="string",
                            cpe_name="string",
                            cpu_bits=1,
                            edition="string",
                            lang="string",
                            name="string",
                            sp_name="string",
                            sp_ver=1,
                            type="string",
                            type_id=1,
                            version="string",
                        ),
                        owner=User(),
                        region="string",
                        risk_level="string",
                        risk_level_id=1,
                        risk_score=1,
                        subnet="string",
                        subnet_uid="string",
                        sw_info=[Product()],
                        type="string",
                        type_id=1,
                        uid="string",
                        uid_alt="string",
                        vendor=Organization(),
                        vlan_uid="string",
                        vpc_uid="string",
                        zone="string",
                    ),
                    duration=1,
                    end_time=1,
                    end_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    enrichments=[
                        Enrichment(
                            data={"key": "value"},
                            name="string",
                            value="string",
                        )
                    ],
                    message="string",
                    metadata=Metadata(
                        correlation_uid="string",
                        event_code="string",
                        extension=Extension(
                            name="string",
                            uid="string",
                            version="string",
                        ),
                        extensions=[
                            Extension(
                                name="string",
                                uid="string",
                                version="string",
                            )
                        ],
                        labels=["string"],
                        log_level="string",
                        log_name="string",
                        log_provider="string",
                        log_version="string",
                        logged_time=1,
                        logged_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        loggers=[Logger()],
                        modified_time=1,
                        modified_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        original_time="string",
                        processed_time=1,
                        processed_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        product=Product(),
                        profiles=["string"],
                        sequence=1,
                        tenant_uid="string",
                        uid="string",
                        version="string",
                    ),
                    observables=[
                        Observable(
                            name="string",
                            type_id=1,
                        )
                    ],
                    osint=[
                        Osint(
                            type_id=1,
                            value="string",
                        )
                    ],
                    raw_data="string",
                    severity="string",
                    severity_id=1,
                    start_time=1,
                    start_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    status="string",
                    status_code="string",
                    status_detail="string",
                    status_id=1,
                    time=1,
                    time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    timezone_offset=1,
                    type_name="string",
                    type_uid=1,
                    unmapped={"string": {"key": "value"}},
                ),
                source_name="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/vulnerabilities/assets/{jsonable_encoder(asset_id)}",
            method="PUT",
            json={
                "asset": asset,
                "source_name": source_name,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    Asset,
                    construct_type(
                        type_=Asset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def query_scans(
        self,
        *,
        meta: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> QueryScansResponse:
        """
        Query scans in a vulnerability scanning system

        Parameters
        ----------
        meta : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Add metadata to the response by invoking meta functions. Documentation for meta functions is available at https://docs.synqly.com/api-reference/meta-functions. Not all meta function are available at every endpoint.

        limit : typing.Optional[int]
            Number of scans to return. Defaults to 50.

        cursor : typing.Optional[str]
            Start search from cursor position.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        QueryScansResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyEngine

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.query_scans(
                meta="string",
                limit=1,
                cursor="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/scans",
            method="GET",
            params={
                "meta": meta,
                "limit": limit,
                "cursor": cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    QueryScansResponse,
                    construct_type(
                        type_=QueryScansResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_scan_activity(
        self, scan_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetScanActivityResponse:
        """
        Get a list of activity generated by a configured scan.

        Parameters
        ----------
        scan_id : str
            ID of the scan to get its activity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetScanActivityResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyEngine

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.get_scan_activity(
                scan_id="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/vulnerabilities/scans/{jsonable_encoder(scan_id)}/activity",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetScanActivityResponse,
                    construct_type(
                        type_=GetScanActivityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def upload_scan(
        self,
        *,
        assets: typing.Sequence[Asset],
        source_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UploadScanResponse:
        """
        Upload a scan in a vulnerability scanning system

        Parameters
        ----------
        assets : typing.Sequence[Asset]
            Assets and optional findings to upload in the vulnerability scanning system.

        source_name : typing.Optional[str]
            Name of the source for this scan, such as a tool or process. Does not have to be unique, defaults to `Integration import`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UploadScanResponse

        Examples
        --------
        import asyncio
        import datetime

        from synqly import AsyncSynqlyEngine
        from synqly.ocsf.v_1_3_0.inventoryinfo.classes import InventoryInfo
        from synqly.ocsf.v_1_3_0.inventoryinfo.objects import (
            Account,
            Actor,
            Agent,
            Api,
            Cloud,
            Container,
            Device,
            DeviceHwInfo,
            Display,
            Enrichment,
            Extension,
            Fingerprint,
            Group,
            Idp,
            Image,
            KeyboardInfo,
            Location,
            Logger,
            Metadata,
            NetworkInterface,
            Observable,
            Organization,
            Os,
            Osint,
            Process,
            Product,
            Request,
            Response,
            Service,
            Session,
            User,
        )

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.upload_scan(
                assets=[
                    InventoryInfo(
                        activity_id=1,
                        activity_name="string",
                        actor=Actor(
                            actor_type="string",
                            actor_type_id=1,
                            app_name="string",
                            app_uid="string",
                            authorizations=[],
                            groups=[],
                            idp=Idp(),
                            invoked_by="string",
                            process=Process(),
                            session=Session(),
                            user=User(),
                        ),
                        api=Api(
                            group=Group(),
                            operation="string",
                            request=Request(
                                uid="string",
                            ),
                            response=Response(),
                            service=Service(),
                            version="string",
                        ),
                        category_name="string",
                        category_uid=1,
                        class_uid=1,
                        cloud=Cloud(
                            account=Account(),
                            org=Organization(),
                            project_uid="string",
                            provider="string",
                            region="string",
                            zone="string",
                        ),
                        count=1,
                        custom_fields={"string": {"key": "value"}},
                        device=Device(
                            agent_list=[Agent()],
                            autoscale_uid="string",
                            boot_time=1,
                            boot_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            container=Container(
                                hash=Fingerprint(
                                    algorithm_id=1,
                                    value="string",
                                ),
                                image=Image(
                                    uid="string",
                                ),
                                name="string",
                                network_driver="string",
                                orchestrator="string",
                                pod_uuid="string",
                                runtime="string",
                                size=1,
                                tag="string",
                                uid="string",
                            ),
                            created_time=1,
                            created_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            desc="string",
                            domain="string",
                            first_seen_time=1,
                            first_seen_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            groups=[Group()],
                            hostname="string",
                            hw_info=DeviceHwInfo(
                                bios_date="string",
                                bios_manufacturer="string",
                                bios_uid="string",
                                bios_ver="string",
                                chassis="string",
                                cpu_bits=1,
                                cpu_cores=1,
                                cpu_count=1,
                                cpu_speed=1,
                                cpu_type="string",
                                desktop_display=Display(),
                                keyboard_info=KeyboardInfo(),
                                ram_size=1,
                                serial_number="string",
                            ),
                            hypervisor="string",
                            image=Image(
                                uid="string",
                            ),
                            imei="string",
                            instance_uid="string",
                            interface_name="string",
                            interface_uid="string",
                            ip="string",
                            ip_addresses=["string"],
                            is_compliant=True,
                            is_managed=True,
                            is_personal=True,
                            is_trusted=True,
                            last_seen_time=1,
                            last_seen_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            location=Location(
                                city="string",
                                continent="string",
                                coordinates=[],
                                country="string",
                                desc="string",
                                geohash="string",
                                is_on_premises=True,
                                isp="string",
                                lat=1.1,
                                long_=1.1,
                                postal_code="string",
                                provider="string",
                                region="string",
                                timezone="string",
                            ),
                            mac="string",
                            mac_addresses=["string"],
                            modified_time=1,
                            modified_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            name="string",
                            namespace_pid=1,
                            netbios_names=["string"],
                            network_interfaces=[
                                NetworkInterface(
                                    type_id=1,
                                )
                            ],
                            network_status="string",
                            network_status_id=1,
                            org=Organization(),
                            os=Os(
                                build="string",
                                country="string",
                                cpe_name="string",
                                cpu_bits=1,
                                edition="string",
                                lang="string",
                                name="string",
                                sp_name="string",
                                sp_ver=1,
                                type="string",
                                type_id=1,
                                version="string",
                            ),
                            owner=User(),
                            region="string",
                            risk_level="string",
                            risk_level_id=1,
                            risk_score=1,
                            subnet="string",
                            subnet_uid="string",
                            sw_info=[Product()],
                            type="string",
                            type_id=1,
                            uid="string",
                            uid_alt="string",
                            vendor=Organization(),
                            vlan_uid="string",
                            vpc_uid="string",
                            zone="string",
                        ),
                        duration=1,
                        end_time=1,
                        end_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        enrichments=[
                            Enrichment(
                                data={"key": "value"},
                                name="string",
                                value="string",
                            )
                        ],
                        message="string",
                        metadata=Metadata(
                            correlation_uid="string",
                            event_code="string",
                            extension=Extension(
                                name="string",
                                uid="string",
                                version="string",
                            ),
                            extensions=[
                                Extension(
                                    name="string",
                                    uid="string",
                                    version="string",
                                )
                            ],
                            labels=["string"],
                            log_level="string",
                            log_name="string",
                            log_provider="string",
                            log_version="string",
                            logged_time=1,
                            logged_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            loggers=[Logger()],
                            modified_time=1,
                            modified_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            original_time="string",
                            processed_time=1,
                            processed_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            product=Product(),
                            profiles=["string"],
                            sequence=1,
                            tenant_uid="string",
                            uid="string",
                            version="string",
                        ),
                        observables=[
                            Observable(
                                name="string",
                                type_id=1,
                            )
                        ],
                        osint=[
                            Osint(
                                type_id=1,
                                value="string",
                            )
                        ],
                        raw_data="string",
                        severity="string",
                        severity_id=1,
                        start_time=1,
                        start_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        status="string",
                        status_code="string",
                        status_detail="string",
                        status_id=1,
                        time=1,
                        time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        timezone_offset=1,
                        type_name="string",
                        type_uid=1,
                        unmapped={"string": {"key": "value"}},
                    )
                ],
                source_name="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/scans",
            method="POST",
            json={
                "assets": assets,
                "source_name": source_name,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UploadScanResponse,
                    construct_type(
                        type_=UploadScanResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_scan_status(
        self, scan_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetScanStatusResponse:
        """
        Get the status of a upload scan

        Parameters
        ----------
        scan_id : str
            ID of the scan to get the status of.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetScanStatusResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyEngine

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.get_scan_status(
                scan_id="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/vulnerabilities/scans/{jsonable_encoder(scan_id)}/status",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetScanStatusResponse,
                    construct_type(
                        type_=GetScanStatusResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_labels(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetLabelsResponse:
        """
        Get labels from an asset inventory system

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetLabelsResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyEngine

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.vulnerabilities.get_labels()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/vulnerabilities/labels",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GetLabelsResponse,
                    construct_type(
                        type_=GetLabelsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
