# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import SyncClientWrapper
import typing
from ..core.request_options import RequestOptions
from .types.list_audit_events_response import ListAuditEventsResponse
from ..core.unchecked_base_model import construct_type
from ..common.errors.bad_request_error import BadRequestError
from ..common.types.problem import Problem
from ..common.errors.unauthorized_error import UnauthorizedError
from ..common.errors.forbidden_error import ForbiddenError
from ..common.errors.not_found_error import NotFoundError
from ..common.errors.method_not_allowed_error import MethodNotAllowedError
from ..common.errors.conflict_error import ConflictError
from ..common.errors.unsupported_media_type_error import UnsupportedMediaTypeError
from ..common.errors.too_many_requests_error import TooManyRequestsError
from ..common.errors.internal_server_error import InternalServerError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper


class AuditClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        start_after: typing.Optional[str] = None,
        order: typing.Optional[str] = None,
        filter: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListAuditEventsResponse:
        """
        Returns a list of all Synqly `Audit` events for the `Organization`.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of `Audit` objects to return in this page. Defaults to 100.

        start_after : typing.Optional[str]
            Return `Audit` objects starting after this `created_at`.

        order : typing.Optional[str]
            The order defaults to created_at[asc] and can changed to descending order by specifying created_at[desc].

        filter : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter results by this query. For more information on filtering, refer to our Filtering Guide. Defaults to no filter.
            If used more than once, the queries are ANDed together.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListAuditEventsResponse

        Examples
        --------
        from synqly import SynqlyManagement

        client = SynqlyManagement(
            token="YOUR_TOKEN",
        )
        client.audit.list(
            limit=1,
            start_after="string",
            order="string",
            filter="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/audit/organizations",
            method="GET",
            params={
                "limit": limit,
                "start_after": start_after,
                "order": order,
                "filter": filter,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListAuditEventsResponse,
                    construct_type(
                        type_=ListAuditEventsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncAuditClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        start_after: typing.Optional[str] = None,
        order: typing.Optional[str] = None,
        filter: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListAuditEventsResponse:
        """
        Returns a list of all Synqly `Audit` events for the `Organization`.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of `Audit` objects to return in this page. Defaults to 100.

        start_after : typing.Optional[str]
            Return `Audit` objects starting after this `created_at`.

        order : typing.Optional[str]
            The order defaults to created_at[asc] and can changed to descending order by specifying created_at[desc].

        filter : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter results by this query. For more information on filtering, refer to our Filtering Guide. Defaults to no filter.
            If used more than once, the queries are ANDed together.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListAuditEventsResponse

        Examples
        --------
        import asyncio

        from synqly import AsyncSynqlyManagement

        client = AsyncSynqlyManagement(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.audit.list(
                limit=1,
                start_after="string",
                order="string",
                filter="string",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/audit/organizations",
            method="GET",
            params={
                "limit": limit,
                "start_after": start_after,
                "order": order,
                "filter": filter,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ListAuditEventsResponse,
                    construct_type(
                        type_=ListAuditEventsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
