# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from .bridge_group_id import BridgeGroupId
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class BridgeGroup(Base):
    """
    A Bridge Group represents a connection between the Synqly Saas or Embedded service and a Bridge Agent. See 'Synqly Bridge Agent' guide in Synqly docs for additional information.
    """

    id: BridgeGroupId
    fullname: str = pydantic.Field()
    """
    Full name of bridge
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the resources included in the bridge and permissions granted on those resources. Includes details of when to use this bridge along with the intended personas.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Labels applied to Bridges within the group. These labels can be used by integrations to select the groups of bridges capable of handling requests to the integration.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
