# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CreateBridgeRequest(UncheckedBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique short name for this Bridge (lowercase [a-z0-9_-], can be used in URLs). Also used for case insensitive duplicate name detection and default sort order. Defaults to BridgeGroupId if both name and fullname are not specified.
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human friendly display name for this Bridge, will auto-generate 'name' field (if 'name' is not specified). Defaults to the same value as the 'name' field if not specified.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the resources included in the bridge and permissions granted on those resources. Includes details of when to use this bridge along with the intended personas.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Bridge selection labels
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
