# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class Availability(str, enum.Enum):
    INTERNAL = "internal"
    """
    Internal use only.
    """

    IN_DEVELOPMENT = "in-development"
    """
    Currently in active development.
    """

    PRE_RELEASE = "pre-release"
    """
    Available for use, but not ready for production.
    """

    DEPRECATED = "deprecated"
    """
    Will be removed in the future.
    """

    GENERALLY_AVAILABLE = "generally-available"
    """
    Stable and available for production use.
    """

    _UNKNOWN = "__AVAILABILITY_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "Availability":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        internal: typing.Callable[[], T_Result],
        in_development: typing.Callable[[], T_Result],
        pre_release: typing.Callable[[], T_Result],
        deprecated: typing.Callable[[], T_Result],
        generally_available: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is Availability.INTERNAL:
            return internal()
        if self is Availability.IN_DEVELOPMENT:
            return in_development()
        if self is Availability.PRE_RELEASE:
            return pre_release()
        if self is Availability.DEPRECATED:
            return deprecated()
        if self is Availability.GENERALLY_AVAILABLE:
            return generally_available()
        return _unknown_member(self._value_)
