# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ProviderEnvironment(str, enum.Enum):
    PRODUCTION = "prod"
    """
    Provider may be used with production accounts.
    """

    TEST = "test"
    """
    Provider may be used with test accounts.
    """

    _UNKNOWN = "__PROVIDERENVIRONMENT_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ProviderEnvironment":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        production: typing.Callable[[], T_Result],
        test: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ProviderEnvironment.PRODUCTION:
            return production()
        if self is ProviderEnvironment.TEST:
            return test()
        return _unknown_member(self._value_)
