# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ResourceId(str, enum.Enum):
    ALERTS = "alerts"
    APPLICATIONS = "applications"
    AUDIT_LOGS = "audit_logs"
    COMMENTS = "comments"
    DEVICES = "devices"
    EVENTS = "events"
    EVIDENCE = "evidence"
    FINDINGS = "findings"
    GROUPS = "groups"
    INVESTIGATIONS = "investigations"
    IOCS = "iocs"
    LOG_PROVIDERS = "log_providers"
    POSTURE_SCORES = "posture_scores"
    PROJECTS = "projects"
    SCANS = "scans"
    SCAN_ACTIVITIES = "scan_activities"
    THREATS = "threats"
    TICKETS = "tickets"
    USERS = "users"
    COMPLIANCE = "compliance"
    CLOUDRESOURCEINVENTORY = "cloudresourceinventory"
    _UNKNOWN = "__RESOURCEID_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ResourceId":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        alerts: typing.Callable[[], T_Result],
        applications: typing.Callable[[], T_Result],
        audit_logs: typing.Callable[[], T_Result],
        comments: typing.Callable[[], T_Result],
        devices: typing.Callable[[], T_Result],
        events: typing.Callable[[], T_Result],
        evidence: typing.Callable[[], T_Result],
        findings: typing.Callable[[], T_Result],
        groups: typing.Callable[[], T_Result],
        investigations: typing.Callable[[], T_Result],
        iocs: typing.Callable[[], T_Result],
        log_providers: typing.Callable[[], T_Result],
        posture_scores: typing.Callable[[], T_Result],
        projects: typing.Callable[[], T_Result],
        scans: typing.Callable[[], T_Result],
        scan_activities: typing.Callable[[], T_Result],
        threats: typing.Callable[[], T_Result],
        tickets: typing.Callable[[], T_Result],
        users: typing.Callable[[], T_Result],
        compliance: typing.Callable[[], T_Result],
        cloudresourceinventory: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ResourceId.ALERTS:
            return alerts()
        if self is ResourceId.APPLICATIONS:
            return applications()
        if self is ResourceId.AUDIT_LOGS:
            return audit_logs()
        if self is ResourceId.COMMENTS:
            return comments()
        if self is ResourceId.DEVICES:
            return devices()
        if self is ResourceId.EVENTS:
            return events()
        if self is ResourceId.EVIDENCE:
            return evidence()
        if self is ResourceId.FINDINGS:
            return findings()
        if self is ResourceId.GROUPS:
            return groups()
        if self is ResourceId.INVESTIGATIONS:
            return investigations()
        if self is ResourceId.IOCS:
            return iocs()
        if self is ResourceId.LOG_PROVIDERS:
            return log_providers()
        if self is ResourceId.POSTURE_SCORES:
            return posture_scores()
        if self is ResourceId.PROJECTS:
            return projects()
        if self is ResourceId.SCANS:
            return scans()
        if self is ResourceId.SCAN_ACTIVITIES:
            return scan_activities()
        if self is ResourceId.THREATS:
            return threats()
        if self is ResourceId.TICKETS:
            return tickets()
        if self is ResourceId.USERS:
            return users()
        if self is ResourceId.COMPLIANCE:
            return compliance()
        if self is ResourceId.CLOUDRESOURCEINVENTORY:
            return cloudresourceinventory()
        return _unknown_member(self._value_)
