# This file was auto-generated by Fern from our API Definition.

from .credential_base import CredentialBase
import typing
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OAuthClientCredential(CredentialBase):
    """
    A Client ID and secret used for authenticating with OAuth 2.0 compatible service using the client credentials grant.
    """

    token_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional URL for the OAuth 2.0 token exchange if it can not be constructed based on provider configuration
    """

    client_id: str = pydantic.Field()
    """
    The ID of the client application defined at the service provider
    """

    client_secret: str = pydantic.Field()
    """
    Secret value for authentication
    """

    extra: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = (
        pydantic.Field(default=None)
    )
    """
    Optional connection specific JSON map data such as a signing key ID or organization ID
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
