# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from ...organization_webhook_base.types.webhook_event import WebhookEvent
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class WebhookItem(UncheckedBaseModel):
    webhook_url: str = pydantic.Field()
    """
    Webhook URL. Events from providers will be sent to this URL.
    """

    event_filter: typing.Optional[typing.List[WebhookEvent]] = pydantic.Field(
        default=None
    )
    """
    If specified, only events matching this list will be sent to `webhook_url`. If no filters are specified, all events sent from providers will be forwarded to `webhook_url`.
    """

    integrator_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    The key used to sign outgoing web hook payloads. If not specified a random key is automatically generated.
    Use this key at the target URL to validate that the incoming payload was signed by Synqly. The payload is signed symmetrically with the `integrator_key` using the `HMAC-SHA256` signature scheme. The key should be randomly generated and between 24 bytes (192 bits) and 64 bytes (512 bits) long.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
