# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .async_operation_request_id import AsyncOperationRequestId
import pydantic
import datetime as dt
from ...common.types.id import Id
from .operation_input import OperationInput
from .operation_status import OperationStatus
import typing
from .operation_error import OperationError
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Operation(UncheckedBaseModel):
    id: AsyncOperationRequestId = pydantic.Field()
    """
    ID of the operation
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time object was originally created
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Last time object was updated
    """

    account_id: Id = pydantic.Field()
    """
    Account ID containing the integration.
    """

    integration_id: Id = pydantic.Field()
    """
    Integration ID to use for the operation.
    """

    operation: str = pydantic.Field()
    """
    Name of the operation that will be run for this operation.
    """

    input: OperationInput = pydantic.Field()
    """
    Parameters for the operation that will be run for this operation.
    """

    status: OperationStatus = pydantic.Field()
    """
    Status of the operation
    """

    errors: typing.Optional[typing.List[OperationError]] = pydantic.Field(default=None)
    """
    Errors that occurred during the operation
    """

    cpu_time: int = pydantic.Field()
    """
    Cpu time in microseconds
    """

    in_bytes: int = pydantic.Field()
    """
    Number of bytes sent to sink integration
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
